/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.io.IOException;
import lime.NamespacePath;
import lime.executor.UploadLimit;
import lime.upload.Upload;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueAttachment;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.NoSuchIssue;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.issue.IssueAttachmentDownload;
import ua.com.softway.tracker.ui.Message;
import ua.com.softway.tracker.ui.Messages;

@NamespacePath(value="/tracker")
@UploadLimit(limit=0xA00000L, limitExceededMethod="limitExceeded")
public class AttachmentAction {
    public String issueKey;
    public Upload file;
    public String name;
    public Messages messages = new Messages();
    private Tracker tracker;

    public AttachmentAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public String form() {
        return "issue/addAttachment";
    }

    public Message limitExceeded() {
        long limit = this.getClass().getAnnotation(UploadLimit.class).limit();
        return new Message("message.upload.limit.exceeded", limit);
    }

    public Object addAttachment() throws IOException {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        if (this.file == null) {
            this.messages.addMessage("attachment.error.notselected", new Object[0]);
            return "issue/addAttachment";
        }
        issue.addAttachment(this.file.getInputStream(), this.file.getName(), this.file.getContentType(), (int)this.file.getSize());
        issue.store();
        return Pages.viewIssue(this.issueKey);
    }

    public Object downloadAttachment() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        IssueAttachment attachment = issue.getAttachment(this.name);
        if (attachment == null) {
            return Pages.viewIssue(this.issueKey);
        }
        return new IssueAttachmentDownload(attachment);
    }

    public Object deleteAttachment() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        issue.deleteAttachment(this.name);
        issue.store();
        return Pages.viewIssue(this.issueKey);
    }
}

