/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.List;
import lime.NamespacePath;
import lime.outcome.Redirect;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.ErrorAction;
import ua.com.softway.tracker.action.NoSuchIssue;
import ua.com.softway.tracker.action.NoSuchUser;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class AssignIssueAction {
    private Tracker tracker;
    public String issueKey;
    public String comment;
    public String assignee;
    public Messages messages = new Messages();

    public AssignIssueAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public Object assignIssueForm() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        if (issue.getAssignee() != null) {
            this.assignee = issue.getAssignee().getLogin();
        }
        return "issue/assignIssue";
    }

    public Object assign() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        if (!issue.getProject().getPermissions().canAssignIssue()) {
            return new Redirect(ErrorAction.class, "noPermissions");
        }
        User assignee = this.tracker.getUser(this.assignee);
        if (assignee == null) {
            return new NoSuchUser(this.assignee);
        }
        issue.setAssignee(assignee);
        if (!Strings.isBlank(this.comment)) {
            issue.addComment(new Comment(User.currentUser(), this.comment));
        }
        issue.store();
        this.tracker.addEvent(new IssueEvent(issue, "notification.assigned"));
        return Pages.viewIssue(this.issueKey);
    }

    public List<SelectOption> getAssigneeOptions() {
        return SelectOptions.user(this.tracker.getUsers(), false);
    }
}

