/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.home;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Direction;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueMatcher;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.action.BrowseIssuesUrl;
import ua.com.softway.tracker.i18n.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionWithOpenIssues {
    private Version version;
    private Project project;

    public VersionWithOpenIssues(Project project, Version version) {
        this.version = version;
        this.project = project;
    }

    public String getName() {
        if (this.version == null) {
            return Resources.getText("projectInfo.open.issues.unplannedVersion");
        }
        return this.version.getName();
    }

    public String getUrl() {
        String fixVersionMatch = this.version != null ? this.version.getKey() : "-";
        BrowseIssuesUrl browseUrl = new BrowseIssuesUrl(true);
        browseUrl.setStatuses(IssueStatus.openStatuses());
        browseUrl.setFixVersion(fixVersionMatch);
        browseUrl.setIssueComparator(IssueField.PRIORITY);
        browseUrl.setIssueDirection(Direction.DESC);
        return browseUrl.getPath();
    }

    public int getOpenIssues() {
        IssueMatcher matcher = new IssueMatcher(Tracker.instance(), this.project.getKey());
        if (this.version != null) {
            matcher.setFix(this.version.getKey());
        } else {
            matcher.setFix("-");
        }
        matcher.setStatuses(IssueStatus.openStatuses());
        return matcher.getMatchedIssues().size();
    }

    public static List<VersionWithOpenIssues> wrap(Project project) {
        ArrayList<VersionWithOpenIssues> result = new ArrayList<VersionWithOpenIssues>();
        if (project.getVersions().isEmpty()) {
            return result;
        }
        for (Version version : project.getVersions()) {
            VersionWithOpenIssues v = new VersionWithOpenIssues(project, version);
            if (v.getOpenIssues() <= 0) continue;
            result.add(v);
        }
        VersionWithOpenIssues unplanned = new VersionWithOpenIssues(project, null);
        if (unplanned.getOpenIssues() > 0) {
            result.add(unplanned);
        }
        return result;
    }
}

