/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.home;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueMatcher;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Portlet;
import ua.com.softway.tracker.issuebrowser.action.IssueBrowser;
import ua.com.softway.tracker.velocity.VelocityTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportedByPortlet
implements Portlet {
    private User reporter;
    private int size;
    private Tracker tracker;

    public ReportedByPortlet(User reporter, int size, Tracker tracker) {
        this.reporter = reporter;
        this.size = size;
        this.tracker = tracker;
    }

    @Override
    public String render() {
        VelocityTemplate template = new VelocityTemplate("portlet/ReportedByPortlet.vm");
        List<IssueField> fields = Arrays.asList(IssueField.KEY, IssueField.STATUS, IssueField.SUMMARY, IssueField.UPDATED);
        IssueBrowser issueBrowser = new IssueBrowser(this.getIssues(), fields);
        template.put("browser", issueBrowser);
        template.put("reporter", this.reporter);
        return template.render();
    }

    private List<Issue> getIssues() {
        List<Issue> issues = new ArrayList<Issue>();
        for (Project project : this.tracker.getProjects()) {
            IssueMatcher matcher = new IssueMatcher(this.tracker, project.getKey());
            matcher.setReporter(this.reporter.getLogin());
            matcher.setStatuses(IssueStatus.openStatuses());
            issues.addAll(matcher.getMatchedIssues());
        }
        Collections.sort(issues, IssueField.UPDATED);
        Collections.reverse(issues);
        if (issues.size() > this.size) {
            issues = issues.subList(0, this.size);
        }
        return issues;
    }
}

