/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.home;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.home.AssigneeWithOpenIssues;
import ua.com.softway.tracker.action.home.ComponentWithOpenIssues;
import ua.com.softway.tracker.action.home.VersionWithOpenIssues;
import ua.com.softway.tracker.permissions.ProjectPermissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectView {
    private Tracker tracker;
    private Project project;

    public ProjectView(Tracker tracker, Project project) {
        this.tracker = tracker;
        this.project = project;
    }

    public String getKey() {
        return this.project.getKey();
    }

    public String getName() {
        return this.project.getName();
    }

    public int getOpenIssues() {
        return this.getIssuesCount(IssueStatus.OPEN);
    }

    public int getTotalIssues() {
        return this.project.getIssues().size();
    }

    public String getTimeReportUrl() {
        return Pages.timeReport(this.project.getKey()).getPath();
    }

    public ProjectPermissions getPermissions() {
        return this.project.getPermissions();
    }

    public List<VersionWithOpenIssues> getIssuesByVersions() {
        return VersionWithOpenIssues.wrap(this.project);
    }

    public List<AssigneeWithOpenIssues> getIssuesByAssignee() {
        return AssigneeWithOpenIssues.wrap(Tracker.instance(), this.project);
    }

    public List<ComponentWithOpenIssues> getIssuesByComponent() {
        return ComponentWithOpenIssues.wrap(this.tracker, this.project);
    }

    private int getIssuesCount(IssueStatus status) {
        int count = 0;
        for (Issue issue : this.project.getIssues()) {
            if (!status.equals(issue.getStatus())) continue;
            ++count;
        }
        return count;
    }

    public static List<ProjectView> wrap(Tracker tracker, List<Project> projects) {
        ArrayList<ProjectView> result = new ArrayList<ProjectView>();
        for (Project project : projects) {
            result.add(new ProjectView(tracker, project));
        }
        return result;
    }

    public static ProjectView wrap(Tracker tracker, Project project) {
        return new ProjectView(tracker, project);
    }
}

