/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.home;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.Portlet;
import ua.com.softway.tracker.velocity.VelocityTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSwitchPortlet
implements Portlet {
    private List<Project> projects;
    private Project current;

    public ProjectSwitchPortlet(List<Project> projects, Project current) {
        this.projects = projects;
        this.current = current;
    }

    @Override
    public String render() {
        VelocityTemplate template = new VelocityTemplate("portlet/ProjectSwitchPortlet.vm");
        ArrayList<SelectableProject> selectableProjects = new ArrayList<SelectableProject>();
        for (Project project : this.projects) {
            selectableProjects.add(new SelectableProject(project));
        }
        template.put("projects", selectableProjects);
        return template.render();
    }

    public class SelectableProject {
        private Project project;

        public SelectableProject(Project project) {
            this.project = project;
        }

        public String getName() {
            return this.project.getName();
        }

        public boolean isCurrent() {
            return this.project.equals(ProjectSwitchPortlet.this.current);
        }

        public String getUrl() {
            return Pages.selectProject(this.project.getKey()).getPath();
        }
    }
}

