/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.home;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lime.NamespacePath;
import lime.outcome.Redirect;
import ua.com.softway.tracker.IssueFilter;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.ObjectPair;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.Portlet;
import ua.com.softway.tracker.action.home.AssignedToPortlet;
import ua.com.softway.tracker.action.home.CurrentProjectPortlet;
import ua.com.softway.tracker.action.home.InProgressPortlet;
import ua.com.softway.tracker.action.home.IssueFilterView;
import ua.com.softway.tracker.action.home.ProjectSwitchPortlet;
import ua.com.softway.tracker.action.home.ProjectView;
import ua.com.softway.tracker.action.home.ReportedByPortlet;
import ua.com.softway.tracker.action.issue.CurrentProject;
import ua.com.softway.tracker.portlet.HomepageSettings;
import ua.com.softway.tracker.portlet.PortletName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class HomeAction {
    private Tracker tracker;
    private CurrentProject currentProject;
    public String filterKey;
    public String projectKey;

    public HomeAction(Tracker tracker, CurrentProject currentProject) {
        this.tracker = tracker;
        this.currentProject = currentProject;
    }

    public Redirect selectProject() {
        Project project = this.tracker.getProject(this.projectKey);
        this.currentProject.setCurrentProject(project);
        return new Redirect(HomeAction.class, "home");
    }

    public String display() {
        return "viewProjects";
    }

    public List<Portlet> getPortlets() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        HomepageSettings settings = User.currentUser().getHomepageSettings();
        for (PortletName portletName : settings.getPortletNames()) {
            if (portletName == PortletName.CURRENT_PROJECT) {
                portlets.add(new CurrentProjectPortlet(this.currentProject.getCurrentProject(), this.tracker));
            }
            if (portletName == PortletName.PROJECT_SWITCH) {
                portlets.add(new ProjectSwitchPortlet(this.tracker.getVisibleProjects(), this.currentProject.getCurrentProject()));
            }
            if (portletName == PortletName.ASSIGNED_TO_ME) {
                portlets.add(new AssignedToPortlet(User.currentUser(), 5, this.tracker));
            }
            if (portletName == PortletName.REPORTED_BY_ME) {
                portlets.add(new ReportedByPortlet(User.currentUser(), 5, this.tracker));
            }
            if (portletName != PortletName.IN_PROGRESS) continue;
            portlets.add(new InProgressPortlet(User.currentUser(), 5, this.tracker));
        }
        return portlets;
    }

    public List<ObjectPair> getProjectPairs() {
        List<ProjectView> projectViews = ProjectView.wrap(this.tracker, this.tracker.getVisibleProjects());
        return ObjectPair.wrap(projectViews);
    }

    public List<ProjectView> getProjects() {
        return ProjectView.wrap(this.tracker, this.tracker.getVisibleProjects());
    }

    public String home() {
        return "home";
    }

    public List<IssueFilterView> getCustomFilters() {
        List<IssueFilter> issueFilters = User.currentUser().getIssueFilters();
        Iterator<IssueFilter> iterator = issueFilters.iterator();
        while (iterator.hasNext()) {
            IssueFilter issueFilter = iterator.next();
            if (this.currentProject.getCurrentProject().getKey().equals(issueFilter.getProject())) continue;
            iterator.remove();
        }
        return IssueFilterView.wrap(issueFilters);
    }

    public Redirect deleteIssueFilter() {
        User user = User.currentUser();
        user.deleteCustomFilter(this.filterKey);
        user.store();
        return Pages.home();
    }

    public ProjectView getCurrentProject() {
        return ProjectView.wrap(this.tracker, this.currentProject.getCurrentProject());
    }
}

