/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.home;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.Direction;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueMatcher;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.BrowseIssuesUrl;
import ua.com.softway.tracker.i18n.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentWithOpenIssues {
    private Component component;
    private Tracker tracker;
    private Project project;

    public ComponentWithOpenIssues(Component component, Tracker tracker, Project project) {
        this.component = component;
        this.tracker = tracker;
        this.project = project;
    }

    public String getComponent() {
        if (this.component == null) {
            return Resources.getText("projectInfo.issuesByComponent.none.component");
        }
        return this.component.getName();
    }

    public int getOpenIssues() {
        IssueMatcher matcher = new IssueMatcher(this.tracker, this.project.getKey());
        if (this.component != null) {
            matcher.setComponent(this.component.getKey());
        } else {
            matcher.setComponent("-");
        }
        matcher.setStatuses(IssueStatus.openStatuses());
        return matcher.getMatchedIssues().size();
    }

    public String getUrl() {
        BrowseIssuesUrl url = new BrowseIssuesUrl(true);
        if (this.component != null) {
            url.setComponent(this.component.getKey());
        } else {
            url.setComponent("-");
        }
        url.setStatuses(IssueStatus.openStatuses());
        url.setIssueComparator(IssueField.PRIORITY);
        url.setIssueDirection(Direction.DESC);
        return url.getPath();
    }

    public static List<ComponentWithOpenIssues> wrap(Tracker tracker, Project project) {
        ArrayList<ComponentWithOpenIssues> result = new ArrayList<ComponentWithOpenIssues>();
        if (project.getComponents().isEmpty()) {
            return result;
        }
        for (Component component : project.getComponents()) {
            ComponentWithOpenIssues componentWithOpenIssues = new ComponentWithOpenIssues(component, tracker, project);
            if (componentWithOpenIssues.getOpenIssues() <= 0) continue;
            result.add(componentWithOpenIssues);
        }
        ComponentWithOpenIssues noneComponentWithIssues = new ComponentWithOpenIssues(null, tracker, project);
        if (noneComponentWithIssues.getOpenIssues() > 0) {
            result.add(noneComponentWithIssues);
        }
        return result;
    }
}

