/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.home;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Direction;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueMatcher;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.BrowseIssuesUrl;
import ua.com.softway.tracker.i18n.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssigneeWithOpenIssues {
    private Project project;
    private User assignee;
    private Tracker tracker;

    public AssigneeWithOpenIssues(User assignee, Tracker tracker, Project project) {
        this.tracker = tracker;
        this.project = project;
        this.assignee = assignee;
    }

    public String getAssignee() {
        if (this.assignee == null) {
            return Resources.getText("projectInfo.issuesByAssignee.unassigned");
        }
        return this.assignee.getName();
    }

    public int getOpenIssues() {
        IssueMatcher matcher = new IssueMatcher(this.tracker, this.project.getKey());
        if (this.assignee != null) {
            matcher.setAssignee(this.assignee.getLogin());
        } else {
            matcher.setAssignee("-");
        }
        matcher.setStatuses(IssueStatus.openStatuses());
        return matcher.getMatchedIssues().size();
    }

    public String getUrl() {
        BrowseIssuesUrl url = new BrowseIssuesUrl(true);
        if (this.assignee != null) {
            url.setAssignee(this.assignee.getLogin());
        } else {
            url.setAssignee("-");
        }
        url.setStatuses(IssueStatus.openStatuses());
        url.setIssueComparator(IssueField.PRIORITY);
        url.setIssueDirection(Direction.DESC);
        return url.getPath();
    }

    public static List<AssigneeWithOpenIssues> wrap(Tracker tracker, Project project) {
        ArrayList<AssigneeWithOpenIssues> result = new ArrayList<AssigneeWithOpenIssues>();
        for (User user : tracker.getUsers()) {
            AssigneeWithOpenIssues assigneeWithOpenIssues = new AssigneeWithOpenIssues(user, tracker, project);
            if (assigneeWithOpenIssues.getOpenIssues() <= 0) continue;
            result.add(assigneeWithOpenIssues);
        }
        AssigneeWithOpenIssues unassignedOpenIssues = new AssigneeWithOpenIssues(null, tracker, project);
        if (unassignedOpenIssues.getOpenIssues() > 0) {
            result.add(unassignedOpenIssues);
        }
        return result;
    }
}

