/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueType;
import ua.com.softway.tracker.Priority;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Resolution;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.ui.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOptions {
    public static List<SelectOption> version(List<Version> versions, boolean hasNone) {
        ArrayList<SelectOption> selectOptions = new ArrayList<SelectOption>();
        if (hasNone) {
            selectOptions.add(SelectOption.NONE_OPTION);
        }
        for (Version version : versions) {
            selectOptions.add(new SelectOption(version.getKey(), version.getName()));
        }
        return selectOptions;
    }

    public static List<SelectOption> priority() {
        ArrayList<SelectOption> selectOptions = new ArrayList<SelectOption>();
        selectOptions.add(new SelectOption(Priority.CRASH.toString(), Priority.CRASH.localizedName()));
        selectOptions.add(new SelectOption(Priority.CRITICAL.toString(), Priority.CRITICAL.localizedName()));
        selectOptions.add(new SelectOption(Priority.IMPORTANT.toString(), Priority.IMPORTANT.localizedName()));
        selectOptions.add(new SelectOption(Priority.NOT_IMPORTANT.toString(), Priority.NOT_IMPORTANT.localizedName()));
        return selectOptions;
    }

    public static List<SelectOption> issueType() {
        IssueType[] issueTypes = IssueType.values();
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        for (IssueType issueType : issueTypes) {
            result.add(new SelectOption(issueType.name(), issueType.localizedName()));
        }
        return result;
    }

    public static List<SelectOption> resolution(List<Resolution> resolutions) {
        ArrayList<SelectOption> selectOptions = new ArrayList<SelectOption>();
        for (Resolution resolution : resolutions) {
            selectOptions.add(new SelectOption(resolution.getCode(), resolution.getName()));
        }
        return selectOptions;
    }

    public static List<SelectOption> project(List<Project> projects, boolean hasNone) {
        ArrayList<SelectOption> selectOptions = new ArrayList<SelectOption>();
        if (hasNone) {
            selectOptions.add(SelectOption.NONE_OPTION);
        }
        for (Project project : projects) {
            selectOptions.add(new SelectOption(project.getKey(), project.getName()));
        }
        return selectOptions;
    }

    public static List<SelectOption> user(List<User> users, boolean hasNone) {
        ArrayList<SelectOption> selectOptions = new ArrayList<SelectOption>();
        if (hasNone) {
            selectOptions.add(SelectOption.NONE_OPTION);
        }
        for (User user : users) {
            selectOptions.add(new SelectOption(user.getLogin(), user.getName()));
        }
        return selectOptions;
    }

    public static List<SelectOption> groups(List<Group> groups, boolean hasNone) {
        ArrayList<SelectOption> selectOptions = new ArrayList<SelectOption>();
        if (hasNone) {
            selectOptions.add(SelectOption.NONE_OPTION);
        }
        for (Group group : groups) {
            selectOptions.add(new SelectOption(group.getKey(), group.getName()));
        }
        return selectOptions;
    }

    public static List<SelectOption> issueComparators() {
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        for (IssueField issueComparator : IssueField.values()) {
            result.add(new SelectOption(issueComparator.name(), issueComparator.localizedName()));
        }
        return result;
    }

    public static List<SelectOption> components(List<Component> components, boolean hasNone) {
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        if (hasNone) {
            result.add(SelectOption.NONE_OPTION);
        }
        for (Component component : components) {
            result.add(new SelectOption(component.getKey(), component.getName()));
        }
        return result;
    }
}

