/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action;

import java.util.ArrayList;
import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.DateFormat;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.UserPreferences;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class PreferencesAction {
    public String emailMyChangesToMe;
    public String locale;
    public String issuePageSize;
    public String datePattern = "";
    public String timePattern = "";
    public Messages messages = new Messages();

    public String form() {
        UserPreferences preferences = User.currentUser().getPreferences();
        if (preferences.isEmailMyChangesToMe()) {
            this.emailMyChangesToMe = "checked";
        }
        this.locale = preferences.getLocale();
        this.issuePageSize = "" + preferences.getIssuePageSize();
        DateFormat dateFormat = User.currentUser().getDateFormat();
        this.datePattern = dateFormat.getDatePattern();
        this.timePattern = dateFormat.getTimePattern();
        return "preferences";
    }

    public List<SelectOption> getLocaleOptions() {
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        result.add(new SelectOption("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439"));
        result.add(new SelectOption("en", "English"));
        return result;
    }

    public List<SelectOption> getDatePatternOptions() {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        DateFormat dateFormat = User.currentUser().getDateFormat();
        for (String pattern : dateFormat.getSupportedDatePatterns()) {
            options.add(new SelectOption(pattern, dateFormat.localizePattern(pattern)));
        }
        return options;
    }

    public List<SelectOption> getTimePatternOptions() {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        DateFormat dateFormat = User.currentUser().getDateFormat();
        for (String pattern : dateFormat.getSupportedTimePatterns()) {
            options.add(new SelectOption(pattern, dateFormat.localizePattern(pattern)));
        }
        return options;
    }

    public Object store() {
        if (Strings.isBlank(this.locale)) {
            this.messages.addMessage("preferences.invalidLocale", new Object[0]);
        }
        if (Strings.isBlank(this.issuePageSize)) {
            this.messages.addMessage("preferences.pageSize.empty", new Object[0]);
        } else {
            try {
                int i = Integer.parseInt(this.issuePageSize);
                if (i < 3) {
                    this.messages.addMessage("preferences.pageSize.tooSmall", 3);
                }
                if (i > 100) {
                    this.messages.addMessage("preferences.pageSize.tooBig", 100);
                }
            }
            catch (NumberFormatException e) {
                this.messages.addMessage("preferences.pageSize.invalidFormat", new Object[0]);
            }
        }
        if (this.emailMyChangesToMe != null) {
            this.emailMyChangesToMe = "checked";
        }
        if (!this.messages.isEmpty()) {
            return "preferences";
        }
        UserPreferences preferences = User.currentUser().getPreferences();
        preferences.setEmailMyChangesToMe(this.emailMyChangesToMe != null);
        preferences.setIssuePageSize(Integer.parseInt(this.issuePageSize));
        preferences.setLocale(this.locale);
        DateFormat dateFormat = User.currentUser().getDateFormat();
        dateFormat.setPatterns(this.datePattern, this.timePattern, this.locale);
        User.currentUser().store();
        return Pages.home();
    }
}

