/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action;

import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.NoSuchProject;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.NoSuchComponent;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class ComponentAction {
    private Tracker tracker;
    public String projectKey = "";
    public String componentKey = "";
    public String name = "";
    public String lead = "";
    public Messages messages = new Messages();

    public ComponentAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public Object components() {
        if (this.tracker.getProject(this.projectKey) == null) {
            return new NoSuchProject(this.projectKey);
        }
        return "manage/componentList";
    }

    public List<Component> getComponents() {
        return this.tracker.getProject(this.projectKey).getComponents();
    }

    public List<SelectOption> getLeadOptions() {
        return SelectOptions.user(this.tracker.getProject(this.projectKey).getPermissions().getAssignees(), true);
    }

    public Object addComponent() {
        Project project = this.tracker.getProject(this.projectKey);
        if (project == null) {
            return new NoSuchProject(this.projectKey);
        }
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("components.error.name.required", new Object[0]);
        }
        if (this.getComponentWithName(project, this.name) != null) {
            this.messages.addMessage("components.error.duplicate.name", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "manage/componentList";
        }
        Component component = project.addComponent(new Component(this.name));
        component.setLead(this.tracker.getUser(this.lead));
        project.store();
        return Pages.manageComponents(this.projectKey);
    }

    private Component getComponentWithName(Project project, String name) {
        for (Component component : project.getComponents()) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public Object editComponent() {
        Project project = this.tracker.getProject(this.projectKey);
        if (project == null) {
            return new NoSuchProject(this.projectKey);
        }
        Component component = project.getComponent(this.componentKey);
        if (component == null) {
            return new NoSuchComponent(this.componentKey);
        }
        this.componentKey = component.getKey();
        this.name = component.getName();
        if (component.getLead() != null) {
            this.lead = component.getLead().getLogin();
        }
        return "manage/editComponent";
    }

    public Object saveComponent() {
        Project project = this.tracker.getProject(this.projectKey);
        if (project == null) {
            return new NoSuchProject(this.projectKey);
        }
        Component component = project.getComponent(this.componentKey);
        if (component == null) {
            return new NoSuchComponent(this.componentKey);
        }
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("components.error.name.required", new Object[0]);
        }
        if (this.getComponentWithName(project, this.name) != null && !component.equals(this.getComponentWithName(project, this.name))) {
            this.messages.addMessage("components.error.duplicate.name", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "manage/editComponent";
        }
        component.setName(this.name);
        component.setLead(this.tracker.getUser(this.lead));
        project.store();
        return Pages.manageComponents(this.projectKey);
    }

    public Object deleteComponent() {
        Project project = this.tracker.getProject(this.projectKey);
        if (project == null) {
            return new NoSuchProject(this.projectKey);
        }
        Component component = project.getComponent(this.componentKey);
        if (component == null) {
            return new NoSuchComponent(this.componentKey);
        }
        project.deleteComponent(component);
        project.store();
        return Pages.manageComponents(this.projectKey);
    }
}

