/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueStatus;

public class Workflow {
    public void close(Issue issue) {
        if (!this.canBeClosed(issue)) {
            throw new IllegalStateException();
        }
        issue.setStatus(IssueStatus.CLOSED);
    }

    public boolean canBeClosed(Issue issue) {
        return issue.getStatus().equals(IssueStatus.OPEN) || issue.getStatus().equals(IssueStatus.RESOLVED) || issue.getStatus().equals(IssueStatus.REOPENED) || issue.getStatus().equals(IssueStatus.IN_PROGRESS);
    }

    public void resolve(Issue issue) {
        if (!this.canBeResolved(issue)) {
            throw new IllegalStateException();
        }
        issue.setStatus(IssueStatus.RESOLVED);
    }

    public boolean canBeResolved(Issue issue) {
        return issue.getStatus().equals(IssueStatus.OPEN) || issue.getStatus().equals(IssueStatus.REOPENED) || issue.getStatus().equals(IssueStatus.IN_PROGRESS);
    }

    public void reopen(Issue issue) {
        if (!this.canBeReopened(issue)) {
            throw new IllegalStateException();
        }
        issue.setStatus(IssueStatus.REOPENED);
        issue.store();
    }

    public boolean canBeReopened(Issue issue) {
        return issue.getStatus().equals(IssueStatus.RESOLVED) || issue.getStatus().equals(IssueStatus.CLOSED);
    }

    public boolean canBeStarted(Issue issue) {
        return issue.getStatus().equals(IssueStatus.OPEN) || issue.getStatus().equals(IssueStatus.REOPENED);
    }

    public void start(Issue issue) {
        if (!this.canBeStarted(issue)) {
            throw new IllegalStateException();
        }
        issue.setStatus(IssueStatus.IN_PROGRESS);
        issue.store();
    }

    public boolean canBeStopped(Issue issue) {
        return issue.getStatus().equals(IssueStatus.IN_PROGRESS);
    }

    public void stop(Issue issue) {
        if (!this.canBeStopped(issue)) {
            throw new IllegalStateException();
        }
        issue.setStatus(IssueStatus.OPEN);
        issue.store();
    }
}

