/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.text.SimpleDateFormat;
import java.util.Date;
import ua.com.softway.tracker.storage.Keys;

public class Version {
    private final String key;
    private String name;
    private boolean released;
    private Date plannedTo;

    public Version(String name) {
        this(name, null);
    }

    public Version(String name, Date plannedTo) {
        this(Keys.getNextKey(), name, plannedTo, false);
    }

    public Version(String key, String name, Date plannedTo, boolean realesed) {
        if (key == null) {
            throw new IllegalArgumentException("key==null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        this.key = key;
        this.name = name;
        this.plannedTo = plannedTo;
        this.released = realesed;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReleased() {
        return this.released;
    }

    public Date getPlannedTo() {
        return this.plannedTo;
    }

    public String getKey() {
        return this.key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlannedTo(Date plannedTo) {
        this.plannedTo = plannedTo;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof Version)) {
            return false;
        }
        Version version = (Version)that;
        return version.name.equals(this.name) && version.key.equals(this.key);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String formattedPlannedTo = this.plannedTo != null ? new SimpleDateFormat(" dd.MM.yyyy").format(this.plannedTo) : "";
        return "Version{" + this.name + formattedPlannedTo + "}";
    }
}

