/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.List;
import ua.com.softway.tracker.DateFormat;
import ua.com.softway.tracker.Direction;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueFilter;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.issuebrowser.IssueBrowserConfiguration;
import ua.com.softway.tracker.portlet.HomepageSettings;
import ua.com.softway.tracker.portlet.PortletName;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserSerializer
implements Serializer<User> {
    UserSerializer() {
    }

    @Override
    public User load(ObjectUpdater<User> updater, Properties properties, String key) {
        User user;
        block19: {
            user = new User(key, properties.getProperty("email"), properties.getProperty("fullName"), updater);
            try {
                user.getPreferences().setIssuePageSize(Integer.parseInt(properties.getProperty("issuePageSize")));
                user.getPreferences().setEmailMyChangesToMe(Boolean.parseBoolean(properties.getProperty("emailMyChangesToMe")));
                user.getPreferences().setLocale(properties.getProperty("locale"));
            }
            catch (Exception ne) {
                if ($assertionsDisabled) break block19;
                throw new AssertionError((Object)"Migrating data between internal versions");
            }
        }
        user.setEncodedPassword(properties.getProperty("password"));
        List<Properties> issueFilters = properties.getList("filters");
        for (Properties p : issueFilters) {
            String directionName;
            String comparatorName;
            IssueFilter issueFilter = new IssueFilter(p.getProperty("key"), p.getProperty("project"));
            issueFilter.setName(p.getProperty("name"));
            issueFilter.setReporter(p.getProperty("reporter"));
            issueFilter.setAssignee(p.getProperty("assignee"));
            issueFilter.setAffects(p.getProperty("affects"));
            issueFilter.setFix(p.getProperty("fix"));
            issueFilter.setStatus(p.getProperty("status"));
            issueFilter.setPriority(p.getProperty("priority"));
            issueFilter.setIssueType(p.getProperty("issueType"));
            issueFilter.setText(p.getProperty("text"));
            if (p.getProperty("component") != null) {
                issueFilter.setComponent(p.getProperty("component"));
            }
            if ((comparatorName = p.getProperty("comparator")) != null) {
                try {
                    IssueField comparator = IssueField.valueOf(comparatorName);
                    issueFilter.setComparator(comparator);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if ((directionName = p.getProperty("direction")) != null) {
                try {
                    Direction direction = Direction.valueOf(directionName);
                    issueFilter.setDirection(direction);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            user.addCustomFilter(issueFilter);
        }
        IssueBrowserConfiguration issueBrowserConfiguration = user.getIssueBrowserConfiguration();
        for (Properties p : properties.getList("issueFields")) {
            try {
                IssueField issueField = IssueField.valueOf(p.getProperty("issueField"));
                issueBrowserConfiguration.addField(issueField);
            }
            catch (IllegalArgumentException e) {}
        }
        if (issueBrowserConfiguration.getFields().isEmpty()) {
            issueBrowserConfiguration.resetToDefault();
        }
        DateFormat dateFormat = user.getDateFormat();
        if (properties.getProperty("datePattern") != null) {
            dateFormat.setPatterns(properties.getProperty("datePattern"), properties.getProperty("timePattern"), user.getPreferences().getLocale());
        }
        HomepageSettings homepageSettings = user.getHomepageSettings();
        for (Properties p : properties.getList("portletNames")) {
            try {
                PortletName portletName = PortletName.valueOf(p.getProperty("portletName"));
                homepageSettings.addPortlet(portletName);
            }
            catch (IllegalArgumentException e) {}
        }
        if (homepageSettings.getPortletNames().isEmpty()) {
            homepageSettings.resetToDefault();
        }
        return user;
    }

    @Override
    public void save(Properties properties, User user) {
        properties.addProperty("password", user.getEncodedPassword());
        properties.addProperty("email", user.getEmail());
        properties.addProperty("fullName", user.getName());
        properties.addProperty("locale", user.getPreferences().getLocale());
        properties.addProperty("issuePageSize", "" + user.getPreferences().getIssuePageSize());
        properties.addProperty("emailMyChangesToMe", "" + user.getPreferences().isEmailMyChangesToMe());
        List<Properties> filterProperties = properties.addList("filters", "filter");
        for (IssueFilter issueFilter : user.getIssueFilters()) {
            Properties p = new Properties();
            p.addProperty("project", issueFilter.getProject());
            p.addProperty("key", issueFilter.getKey());
            p.addProperty("name", issueFilter.getName());
            p.addProperty("reporter", issueFilter.getReporter());
            p.addProperty("assignee", issueFilter.getAssignee());
            p.addProperty("affects", issueFilter.getAffects());
            p.addProperty("fix", issueFilter.getFix());
            p.addProperty("status", issueFilter.getStatus());
            p.addProperty("priority", issueFilter.getPriority());
            p.addProperty("issueType", issueFilter.getIssueType());
            p.addProperty("component", issueFilter.getComponent());
            p.addProperty("text", issueFilter.getText());
            p.addProperty("comparator", issueFilter.getComparator().name());
            p.addProperty("direction", issueFilter.getDirection().name());
            filterProperties.add(p);
        }
        List<Properties> issueFieldsProperties = properties.addList("issueFields", "issueField");
        for (IssueField issueField : user.getIssueBrowserConfiguration().getFields()) {
            Properties p = new Properties();
            p.addProperty("issueField", issueField.name());
            issueFieldsProperties.add(p);
        }
        properties.addProperty("datePattern", user.getDateFormat().getDatePattern());
        properties.addProperty("timePattern", user.getDateFormat().getTimePattern());
        List<Properties> portletNamesProperties = properties.addList("portletNames", "portletName");
        for (PortletName portletName : user.getHomepageSettings().getPortletNames()) {
            Properties p = new Properties();
            p.addProperty("portletName", portletName.name());
            portletNamesProperties.add(p);
        }
    }

    @Override
    public String getKey(User object) {
        return object.getLogin();
    }
}

