/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.misc.BASE64Encoder;
import ua.com.softway.tracker.DateFormat;
import ua.com.softway.tracker.IssueFilter;
import ua.com.softway.tracker.UserPreferences;
import ua.com.softway.tracker.issuebrowser.IssueBrowserConfiguration;
import ua.com.softway.tracker.portlet.HomepageSettings;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
implements Comparable<User> {
    private String login;
    private String encodedPassword;
    private String email;
    private String name;
    private UserPreferences preferences = new UserPreferences();
    private DateFormat dateFormat = new DateFormat();
    private HomepageSettings homepageSettings = new HomepageSettings();
    private List<IssueFilter> customFilters = new ArrayList<IssueFilter>();
    private ObjectUpdater<User> updater;
    private IssueBrowserConfiguration issueBrowserConfiguration = new IssueBrowserConfiguration();
    static ThreadLocal<User> threadLocalUser = new ThreadLocal();

    User(String login, String email, String name, ObjectUpdater<User> updater) {
        this.login = login;
        this.email = email;
        this.name = name;
        this.updater = updater;
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setName(String fullName) {
        this.name = fullName;
    }

    @Override
    public int compareTo(User right) {
        return this.name.compareTo(right.name);
    }

    public void store() {
        this.updater.saveOrUpdate(this);
    }

    public UserPreferences getPreferences() {
        return this.preferences;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public HomepageSettings getHomepageSettings() {
        return this.homepageSettings;
    }

    public void addCustomFilter(IssueFilter filter) {
        this.customFilters.add(filter);
    }

    public List<IssueFilter> getIssueFilters() {
        return new ArrayList<IssueFilter>(this.customFilters);
    }

    public IssueFilter getIssueFilter(String filterKey) {
        for (IssueFilter issueFilter : this.customFilters) {
            if (!issueFilter.getKey().equals(filterKey)) continue;
            return issueFilter;
        }
        return null;
    }

    public void deleteCustomFilter(String filterKey) {
        Iterator<IssueFilter> iterator = this.customFilters.iterator();
        while (iterator.hasNext()) {
            IssueFilter issueFilter = iterator.next();
            if (!issueFilter.getKey().equals(filterKey)) continue;
            iterator.remove();
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof User)) {
            return false;
        }
        User user = (User)that;
        return user.login.equals(this.login);
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public boolean isCorrectPassword(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return this.encodedPassword.equals(User.hash(s));
    }

    public void setPassword(String password) {
        this.encodedPassword = User.hash(password);
    }

    void setEncodedPassword(String encodedPassword) {
        this.encodedPassword = encodedPassword;
    }

    String getEncodedPassword() {
        return this.encodedPassword;
    }

    static String hash(String s) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(s.getBytes());
        byte[] result = md.digest();
        return new BASE64Encoder().encode(result);
    }

    public String resetPassword() {
        String password = User.generateNewPassword();
        this.setPassword(password);
        return password;
    }

    private static String generateNewPassword() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 7; ++i) {
            buffer.append((char)(65.0 + 23.0 * Math.random()));
        }
        return buffer.toString();
    }

    public IssueBrowserConfiguration getIssueBrowserConfiguration() {
        return this.issueBrowserConfiguration;
    }

    public String toString() {
        return "User{" + this.login + "}";
    }

    public static User currentUser() {
        return threadLocalUser.get();
    }

    public static void setCurrentUser(User user) {
        threadLocalUser.set(user);
    }
}

