/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.DuplicateNameException;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.GroupSerializer;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.ProjectSerializer;
import ua.com.softway.tracker.SystemSettings;
import ua.com.softway.tracker.SystemSettingsSerializer;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.UserSerializer;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.events.EventRecorder;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.events.MailerDeamon;
import ua.com.softway.tracker.events.Notifier;
import ua.com.softway.tracker.events.PasswordResetEmail;
import ua.com.softway.tracker.events.TrackerEventListener;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.permissions.PermissionManager;
import ua.com.softway.tracker.storage.Keys;
import ua.com.softway.tracker.storage.ObjectDirectory;
import ua.com.softway.tracker.storage.SingleObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tracker {
    private final ObjectDirectory<User> userDirectory;
    private final ObjectDirectory<Project> projectDirectory;
    private final ObjectDirectory<Group> groupDirectory;
    private final SingleObjectStore<SystemSettings> systemSettingsStore;
    private final List<TrackerEventListener> eventListeners;
    private final EventRecorder eventRecorder;
    private Folder trackerFolder;
    private static Tracker instance;

    public static Tracker configure(Folder trackerFolder) {
        instance = new Tracker(trackerFolder);
        return instance;
    }

    public static Tracker instance() {
        if (instance == null) {
            throw new IllegalStateException("tracker not configured");
        }
        return instance;
    }

    private Tracker(Folder trackerFolder) {
        this.trackerFolder = trackerFolder;
        Folder userFolder = trackerFolder.getFolder("users");
        this.userDirectory = new ObjectDirectory<User>(new UserSerializer(), userFolder);
        Folder groupsFolder = trackerFolder.getFolder("groups");
        this.groupDirectory = new ObjectDirectory<Group>(new GroupSerializer(this), groupsFolder);
        if (this.getAllUsersGroup() == null) {
            this.createGroup("users");
        }
        if (this.getAdministratorsGroup() == null) {
            this.createGroup("administrators");
        }
        Folder projectsFolder = trackerFolder.getFolder("projects");
        this.projectDirectory = new ObjectDirectory<Project>(new ProjectSerializer(this), projectsFolder);
        File systemSettingsFile = trackerFolder.getFile("settings");
        this.systemSettingsStore = new SingleObjectStore<SystemSettings>(new SystemSettingsSerializer(), systemSettingsFile);
        if (this.systemSettingsStore.getObject() == null) {
            this.systemSettingsStore.saveOrUpdate(new SystemSettings(this.systemSettingsStore));
        }
        this.eventListeners = new ArrayList<TrackerEventListener>();
        this.eventRecorder = new EventRecorder(trackerFolder.getFolder("events"));
        Notifier notifier = new Notifier();
        this.eventListeners.add(this.eventRecorder);
        this.eventListeners.add(notifier);
    }

    public User getUser(String login) {
        return this.userDirectory.getObjects().get(login);
    }

    public List<User> getUsers() {
        Collection<User> values = this.userDirectory.getObjects().values();
        return new ArrayList<User>(values);
    }

    public User createUser(String login, String password, String email, String name) throws DuplicateNameException {
        if (this.userDirectory.getObjects().containsKey(login)) {
            throw new DuplicateNameException();
        }
        User user = new User(login, email, name, this.userDirectory);
        user.setPassword(password);
        user.getIssueBrowserConfiguration().resetToDefault();
        user.getHomepageSettings().resetToDefault();
        this.userDirectory.saveOrUpdate(user);
        this.getAllUsersGroup().addUser(user);
        this.getAllUsersGroup().store();
        return user;
    }

    public void deleteUser(String login) {
        User user = this.userDirectory.getObjects().get(login);
        if (user == null) {
            throw new IllegalArgumentException("No such user");
        }
        this.userDirectory.delete(login);
        for (Group group : this.getGroups()) {
            if (!group.containsUser(user)) continue;
            group.removeUser(login);
            group.store();
        }
        for (Project project : this.getProjects()) {
            for (Issue issue : project.getIssues()) {
                boolean updated = false;
                for (Comment comment : issue.getComments()) {
                    if (!user.equals(comment.getAuthor())) continue;
                    comment.setAuthor(null);
                    updated = true;
                }
                if (user.equals(issue.getAssignee())) {
                    issue.setAssignee(null);
                    updated = true;
                }
                if (user.equals(issue.getReporter())) {
                    issue.setReporter(null);
                    updated = true;
                }
                if (issue.getWatchers().contains(user)) {
                    issue.getWatchers().remove(user);
                    updated = true;
                }
                if (!updated) continue;
                issue.store();
            }
            for (PermissionManager.PermissionType type : PermissionManager.PermissionType.values()) {
                project.getPermissionManager().disallow(type, user);
            }
            project.getPermissionManager().store();
        }
    }

    public Group getAllUsersGroup() {
        for (Group g : this.getGroups()) {
            if (!"users".equals(g.getName())) continue;
            return g;
        }
        return null;
    }

    public Group getAdministratorsGroup() {
        for (Group g : this.getGroups()) {
            if (!"administrators".equals(g.getName())) continue;
            return g;
        }
        return null;
    }

    public List<Group> getGroups() {
        Collection<Group> values = this.groupDirectory.getObjects().values();
        return new ArrayList<Group>(values);
    }

    public Group getGroupWithName(String name) {
        for (Group group : this.getGroups()) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public Group createGroup(String name) {
        Group group = new Group(Keys.getNextKey(), this.groupDirectory, name, new HashSet<User>());
        this.groupDirectory.saveOrUpdate(group);
        return group;
    }

    public void deleteGroup(String key) {
        Group group = this.groupDirectory.getObjects().get(key);
        if (group == null) {
            throw new IllegalArgumentException("No such group");
        }
        this.groupDirectory.delete(key);
        for (Project project : this.getProjects()) {
            for (PermissionManager.PermissionType type : PermissionManager.PermissionType.values()) {
                project.getPermissionManager().disallow(type, group);
            }
            project.getPermissionManager().store();
        }
    }

    public Group getGroup(String key) {
        return this.groupDirectory.getObjects().get(key);
    }

    public List<Project> getProjects() {
        Collection<Project> values = this.projectDirectory.getObjects().values();
        return new ArrayList<Project>(values);
    }

    public List<Project> getVisibleProjects() {
        Collection<Project> values = this.projectDirectory.getObjects().values();
        ArrayList<Project> result = new ArrayList<Project>(values);
        Iterator<Project> i = result.iterator();
        while (i.hasNext()) {
            Project project = i.next();
            if (project.getPermissions().isProjectVisible()) continue;
            i.remove();
        }
        return result;
    }

    public Project createProject(String key, String name) throws DuplicateNameException {
        if (!key.toUpperCase().equals(key)) {
            throw new IllegalArgumentException("Project key should be uppercase");
        }
        if (this.getProject(key) != null) {
            throw new DuplicateNameException();
        }
        Project project = new Project(key, name, this.projectDirectory, this, new ArrayList<Version>());
        project.initialize(this.getProjectParentFolder());
        this.projectDirectory.saveOrUpdate(project);
        return project;
    }

    Folder getProjectParentFolder() {
        return this.trackerFolder.getFolder("projects");
    }

    Folder getAttachmentFolder() {
        return this.trackerFolder.getFolder("attachments");
    }

    public void deleteProject(String projectKey) {
        this.getProject(projectKey).getIssueFolder(this.getProjectParentFolder()).delete();
        this.getProjectParentFolder().getFolder("permissions").getFile(projectKey).delete();
        this.projectDirectory.delete(projectKey);
    }

    public Project getProject(String projectKey) {
        return this.projectDirectory.getObjects().get(projectKey);
    }

    public Issue getIssue(String issueKey) {
        for (Project project : this.getVisibleProjects()) {
            Issue issue = project.getIssue(issueKey);
            if (issue == null) continue;
            return issue;
        }
        return null;
    }

    public List<Issue> getVisibleIssues() {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Project project : this.getVisibleProjects()) {
            for (Issue issue : project.getIssues()) {
                issues.add(issue);
            }
        }
        return issues;
    }

    public EventRecorder getEventRecorder() {
        return this.eventRecorder;
    }

    public void addEvent(IssueEvent event) {
        for (TrackerEventListener listener : this.eventListeners) {
            listener.event(event);
        }
    }

    public String resetPassword(User user) {
        String password = user.resetPassword();
        MailerDeamon.add(new PasswordResetEmail(user, password));
        return password;
    }

    public SystemSettings getSystemSettings() {
        return this.systemSettingsStore.getObject();
    }
}

