/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemSettings {
    private String smtpHost = "";
    private String fromEmail = "clarity@softway.com.ua";
    private String signature = "\n--\nThis message is automatically generated by Clarity Issue tracker\n";
    private String publicUrl = "http://127.0.0.1:8080/";
    private final ObjectUpdater<SystemSettings> updater;
    private String smtpPassword;

    public SystemSettings(ObjectUpdater<SystemSettings> updater) {
        this.updater = updater;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public Session getMailSession() {
        if (Strings.isBlank(this.getSmtpHost())) {
            return null;
        }
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.getSmtpHost());
        if (Strings.isBlank(this.getSmtpPassword())) {
            return Session.getInstance(properties);
        }
        properties.put("mail.smtp.auth", "true");
        return Session.getDefaultInstance(properties, new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SystemSettings.this.getFromEmail(), SystemSettings.this.getSmtpPassword());
            }
        });
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public void store() {
        this.updater.saveOrUpdate(this);
    }
}

