/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectSerializer
implements Serializer<Project> {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private final Tracker tracker;

    ProjectSerializer(Tracker users) {
        this.tracker = users;
    }

    @Override
    public Project load(ObjectUpdater<Project> updater, Properties properties, String key) {
        List<Properties> versionsProperties = properties.getList("versions");
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Properties p : versionsProperties) {
            Date plannedTo = null;
            if (p.getProperty("plannedTo") != null) {
                try {
                    plannedTo = this.dateFormat.parse(p.getProperty("plannedTo"));
                }
                catch (ParseException e) {
                    plannedTo = null;
                }
            }
            boolean versionReleased = Boolean.parseBoolean(p.getProperty("released"));
            versions.add(new Version(p.getProperty("key"), p.getProperty("name"), plannedTo, versionReleased));
        }
        Project project = new Project(key, properties.getProperty("name"), updater, this.tracker, versions);
        project.setDefaultAssignee(this.tracker.getUser(properties.getProperty("defaultAssignee")));
        for (Properties p : properties.getList("components")) {
            Component component = new Component(p.getProperty("key"), p.getProperty("name"));
            User leader = this.tracker.getUser(p.getProperty("lead"));
            if (leader != null) {
                component.setLead(leader);
            }
            project.addComponent(component);
        }
        project.initialize(this.tracker.getProjectParentFolder());
        return project;
    }

    @Override
    public void save(Properties properties, Project project) {
        properties.addProperty("name", project.getName());
        if (project.getDefaultAssignee() != null) {
            properties.addProperty("defaultAssignee", project.getDefaultAssignee().getLogin());
        }
        List<Properties> versionsProperties = properties.addList("versions", "version");
        for (Version version : project.getVersions()) {
            Properties p = new Properties();
            p.addProperty("key", version.getKey());
            p.addProperty("name", version.getName());
            if (version.getPlannedTo() != null) {
                String formatedPlannedTo = this.dateFormat.format(version.getPlannedTo());
                p.addProperty("plannedTo", formatedPlannedTo);
            }
            p.addProperty("released", String.valueOf(version.isReleased()));
            versionsProperties.add(p);
        }
        List<Properties> componentProperties = properties.addList("components", "component");
        for (Component component : project.getComponents()) {
            Properties p = new Properties();
            p.addProperty("key", component.getKey());
            p.addProperty("name", component.getName());
            if (component.getLead() != null) {
                p.addProperty("lead", component.getLead().getLogin());
            }
            componentProperties.add(p);
        }
    }

    @Override
    public String getKey(Project object) {
        return object.getKey();
    }
}

