/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.DuplicateNameException;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueAttachment;
import ua.com.softway.tracker.IssueSerializer;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.IssueType;
import ua.com.softway.tracker.Priority;
import ua.com.softway.tracker.Resolution;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.Workflow;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.permissions.PermissionChangeListener;
import ua.com.softway.tracker.permissions.PermissionManager;
import ua.com.softway.tracker.permissions.PermissionManagerSerializer;
import ua.com.softway.tracker.permissions.ProjectPermissions;
import ua.com.softway.tracker.storage.ObjectDirectory;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.SingleObjectStore;
import ua.com.softway.tracker.util.InvalidIssueKeyException;
import ua.com.softway.tracker.util.IssueKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private Tracker tracker;
    private final String key;
    private String name;
    private User defaultAssignee;
    private final ObjectUpdater<Project> updater;
    private List<Version> versions;
    private ObjectDirectory<Issue> issueDirectory;
    private SingleObjectStore<PermissionManager> permissions;
    private List<Component> components;

    Project(String key, String name, ObjectUpdater<Project> updater, Tracker tracker, List<Version> versions) {
        this.key = key;
        this.name = name;
        this.updater = updater;
        this.tracker = tracker;
        this.versions = versions;
        this.components = new ArrayList<Component>();
    }

    protected void initialize(Folder projectParentFolder) {
        this.issueDirectory = new ObjectDirectory<Issue>(new IssueSerializer(this.tracker, this), this.getIssueFolder(projectParentFolder));
        File permissionsFile = projectParentFolder.getFolder("permissions").getFile(this.key);
        this.permissions = new SingleObjectStore<PermissionManager>(new PermissionManagerSerializer(this.tracker), permissionsFile);
        if (this.permissions.getObject() == null) {
            PermissionManager projectPermissions = new PermissionManager(this.permissions);
            for (PermissionManager.PermissionType type : PermissionManager.PermissionType.values()) {
                projectPermissions.allow(type, this.tracker.getAllUsersGroup());
            }
            this.permissions.saveOrUpdate(projectPermissions);
        }
        this.permissions.getObject().setListener(new NullAssigneePermissionChangeListener());
    }

    public Folder getIssueFolder(Folder projectParentFolder) {
        return projectParentFolder.getFolder(this.key + ".issues");
    }

    private int getNewIssueIndex() {
        List<Issue> issues = this.getIssues();
        if (issues.isEmpty()) {
            return 1;
        }
        int maxIndex = 1;
        for (Issue issue : issues) {
            int index = 1;
            try {
                index = new IssueKey(issue.getKey()).getIssueIndex();
            }
            catch (InvalidIssueKeyException e) {
                // empty catch block
            }
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        return maxIndex + 1;
    }

    private String getNewIssueKey() {
        return this.key + "-" + this.getNewIssueIndex();
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Issue createIssue(String summary, String description, User reporter, User assignee, Version affects, Version fix, IssueType type, Priority priority, Resolution resolution) {
        return this.createIssue(summary, description, reporter, assignee, affects, fix, this.getNewIssueKey(), IssueStatus.OPEN, type, priority, resolution);
    }

    Issue createIssue(String summary, String description, User reporter, User assigne, Version affects, Version fix, String key, IssueStatus status, IssueType type, Priority priority, Resolution resolution) {
        Issue issue = new Issue(this.issueDirectory, this, key);
        issue.setSummary(summary);
        issue.setDescription(description);
        issue.setReporter(reporter);
        issue.setAssignee(assigne);
        issue.setStatus(status);
        issue.setAffectsVersion(affects);
        issue.setFixVersion(fix);
        issue.setType(type);
        issue.setPriority(priority);
        issue.setResolution(resolution);
        issue.store();
        return issue;
    }

    public Issue addIssue() {
        Issue issue = new Issue(this.issueDirectory, this, this.getNewIssueKey());
        return issue;
    }

    public List<Issue> getIssues() {
        Collection<Issue> c = this.issueDirectory.getObjects().values();
        return new ArrayList<Issue>(c);
    }

    public Issue getIssue(String issueKey) {
        return this.issueDirectory.getObjects().get(issueKey);
    }

    public List<Version> getVersions() {
        return new ArrayList<Version>(this.versions);
    }

    public Version getVersion(String versionKey) {
        for (Version version : this.versions) {
            if (!version.getKey().equals(versionKey)) continue;
            return version;
        }
        return null;
    }

    public Version addVersion(Version version) throws DuplicateNameException {
        for (Version v : this.versions) {
            if (!v.getName().equals(version.getName())) continue;
            throw new DuplicateNameException("project " + this + " already contains version " + version);
        }
        this.versions.add(version);
        return version;
    }

    private void reassignIssuesOf(Version version) {
        for (Issue issue : this.getIssues()) {
            if (version.equals(issue.getFix())) {
                issue.setFixVersion(null);
                issue.store();
            }
            if (!version.equals(issue.getAffects())) continue;
            issue.setAffectsVersion(null);
            issue.store();
        }
    }

    public void deleteVersion(String versionKey) {
        Iterator<Version> iterator = this.versions.iterator();
        while (iterator.hasNext()) {
            Version version = iterator.next();
            if (!version.getKey().equals(versionKey)) continue;
            iterator.remove();
            this.reassignIssuesOf(version);
            break;
        }
    }

    public Workflow getWorkflow() {
        return new Workflow();
    }

    public void deleteIssue(Issue issue) {
        for (IssueAttachment attachment : issue.getAttachments()) {
            attachment.delete();
        }
        this.issueDirectory.delete(issue.getKey());
    }

    public void store() {
        this.updater.saveOrUpdate(this);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Project) {
            Project project = (Project)obj;
            return this.key.equals(project.key);
        }
        return false;
    }

    public int getVersionPosition(Version version) {
        int i = 0;
        for (Version v : this.getVersions()) {
            if (v.equals(version)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setVersionPosition(Version version, int newPosition) {
        int oldPosition = this.getVersionPosition(version);
        if (oldPosition == -1) {
            throw new IllegalArgumentException();
        }
        if (newPosition > this.getVersions().size() || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        if (newPosition == oldPosition) {
            return;
        }
        this.versions.remove(oldPosition);
        this.versions.add(newPosition, version);
    }

    public IssueType getDefaultIssueType() {
        return IssueType.DEFECT;
    }

    public Priority getDefaultPriority() {
        return Priority.IMPORTANT;
    }

    public List<Resolution> getResolutions() {
        ArrayList<Resolution> result = new ArrayList<Resolution>();
        result.add(new Resolution(0, "resolution.fixed"));
        result.add(new Resolution(1, "resolution.wontfix"));
        result.add(new Resolution(2, "resolution.duplicate"));
        result.add(new Resolution(3, "resolution.incomplete"));
        result.add(new Resolution(4, "resolution.cantreproduce"));
        result.add(new Resolution(5, "resolution.notabug"));
        return result;
    }

    public Resolution getResolution(int code) {
        for (Resolution resolution : this.getResolutions()) {
            if (resolution.getCode() != code) continue;
            return resolution;
        }
        return null;
    }

    public Resolution getDefaultResolution() {
        return this.getResolution(0);
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public ProjectPermissions getPermissions() {
        return this.permissions.getObject();
    }

    public PermissionManager getPermissionManager() {
        return this.permissions.getObject();
    }

    public User getDefaultAssignee() {
        return this.defaultAssignee;
    }

    public void setDefaultAssignee(User defaultAssignee) {
        this.defaultAssignee = defaultAssignee;
    }

    public List<Component> getComponents() {
        return new ArrayList<Component>(this.components);
    }

    public Component addComponent(Component component) {
        this.components.add(component);
        return component;
    }

    public Component getComponent(String componentKey) {
        for (Component component : this.components) {
            if (!component.getKey().equals(componentKey)) continue;
            return component;
        }
        return null;
    }

    public void deleteComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component is null");
        }
        for (Issue issue : this.getIssues()) {
            if (!component.equals(issue.getComponent())) continue;
            issue.setComponent(null);
            issue.store();
        }
        this.components.remove(component);
    }

    private class NullAssigneePermissionChangeListener
    implements PermissionChangeListener {
        private NullAssigneePermissionChangeListener() {
        }

        public void permissionChanged(PermissionManager.PermissionType type, User user, boolean allowed) {
            this.checkDefaultAssignee(type);
        }

        public void permissionChanged(PermissionManager.PermissionType type, Group group, boolean allowed) {
            this.checkDefaultAssignee(type);
        }

        private void checkDefaultAssignee(PermissionManager.PermissionType type) {
            if (type == PermissionManager.PermissionType.Assignable && !Project.this.getPermissions().getAssignees().contains(Project.this.getDefaultAssignee())) {
                Project.this.setDefaultAssignee(null);
                Project.this.store();
            }
        }
    }
}

