/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.jiraws.JiraSoapService;
import ua.com.softway.tracker.jiraws.JiraSoapServiceServiceLocator;
import ua.com.softway.tracker.jiraws.RemoteAuthenticationException;
import ua.com.softway.tracker.jiraws.RemoteComment;
import ua.com.softway.tracker.jiraws.RemoteException;
import ua.com.softway.tracker.jiraws.RemoteIssue;
import ua.com.softway.tracker.jiraws.RemotePermissionException;
import ua.com.softway.tracker.jiraws.RemoteProject;
import ua.com.softway.tracker.jiraws.RemoteUser;
import ua.com.softway.tracker.jiraws.RemoteValidationException;
import ua.com.softway.tracker.jiraws.RemoteVersion;

public class JiraMigration
implements Runnable {
    private JiraSoapService jira;
    private String token;
    private Tracker tracker;
    private String projectKey;
    private boolean completed = false;
    private StringBuffer sb = new StringBuffer();
    private RemoteUser[] jiraUsers;

    public JiraMigration(String jiraUrl, Tracker tracker, String login, String password, String projectKey) {
        this.tracker = tracker;
        this.projectKey = projectKey;
        JiraSoapServiceServiceLocator locator = new JiraSoapServiceServiceLocator();
        try {
            URL portAddress = new URL(jiraUrl + "/rpc/soap/jirasoapservice-v2");
            this.jira = locator.getJirasoapserviceV2(portAddress);
            this.token = this.jira.login(login, password);
        }
        catch (ServiceException e) {
            this.log("Can't connect to JIRA: " + e.getMessage());
            this.completed = true;
        }
        catch (MalformedURLException e) {
            this.log("Can't connect to JIRA: " + e.getMessage());
            this.completed = true;
        }
        catch (RemoteAuthenticationException e) {
            this.log("Can't connect to JIRA: " + e.getMessage());
            this.completed = true;
        }
        catch (RemoteException e) {
            this.log("Can't connect to JIRA: " + e.getMessage());
            this.completed = true;
        }
        catch (java.rmi.RemoteException e) {
            this.log("Can't connect to JIRA: " + e.getMessage());
            this.completed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            RemoteProject[] projects;
            for (RemoteProject remoteProject : projects = this.jira.getProjects(this.token)) {
                if (!remoteProject.getKey().equals(this.projectKey)) continue;
                this.migrateProject(remoteProject);
            }
        }
        catch (RemoteException e) {
            this.log("Can't connect to JIRA: " + e.getMessage());
        }
        catch (java.rmi.RemoteException e) {
            this.log("Can't connect to JIRA: " + e.getMessage());
        }
        finally {
            this.completed = true;
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private void migrateProject(RemoteProject remoteProject) throws RemotePermissionException, RemoteAuthenticationException, RemoteException, java.rmi.RemoteException {
        RemoteIssue[] remoteIssues;
        RemoteVersion[] remoteVersions;
        String projectKey = remoteProject.getKey();
        if (this.tracker.getProject(projectKey) != null) {
            return;
        }
        this.tracker.createProject(projectKey, remoteProject.getName());
        Project project = this.tracker.getProject(projectKey);
        for (RemoteVersion remoteVersion : remoteVersions = this.jira.getVersions(this.token, remoteProject.getKey())) {
            Date releaseDate = null;
            if (remoteVersion.getReleaseDate() != null) {
                releaseDate = remoteVersion.getReleaseDate().getTime();
            }
            project.addVersion(new Version(remoteVersion.getId(), remoteVersion.getName(), releaseDate, remoteVersion.isReleased()));
        }
        for (RemoteIssue remoteIssue : remoteIssues = this.jira.getIssuesFromTextSearchWithProject(this.token, new String[]{projectKey}, "", 100000)) {
            RemoteVersion[] remoteAffectsVersion = remoteIssue.getAffectsVersions();
            RemoteVersion[] remoteFixVersion = remoteIssue.getFixVersions();
            String assigneeName = remoteIssue.getAssignee();
            String reporterName = remoteIssue.getReporter();
            User assignee = this.migrateUserIfRequired(assigneeName);
            User reporter = this.migrateUserIfRequired(reporterName);
            Version affects = null;
            Version fix = null;
            if (remoteAffectsVersion.length > 0) {
                affects = project.getVersion(remoteAffectsVersion[0].getId());
            }
            if (remoteFixVersion.length > 0) {
                fix = project.getVersion(remoteFixVersion[0].getId());
            }
            Issue issue = project.createIssue(remoteIssue.getSummary(), remoteIssue.getDescription(), reporter, assignee, affects, fix, remoteIssue.getKey(), this.convertStatus(remoteIssue.getStatus()), project.getDefaultIssueType(), project.getDefaultPriority(), null);
            for (RemoteComment remoteComment : this.jira.getComments(this.token, remoteIssue.getKey())) {
                User author = this.migrateUserIfRequired(remoteComment.getUsername());
                Date posted = null;
                if (remoteComment.getTimePerformed() != null) {
                    posted = remoteComment.getTimePerformed().getTime();
                }
                issue.addComment(new Comment(remoteComment.getId(), author, remoteComment.getBody(), posted));
            }
            issue.store();
        }
        this.log("Migrated project " + remoteProject.getName());
    }

    private IssueStatus convertStatus(String jiraStatus) {
        if ("1".equals(jiraStatus)) {
            return IssueStatus.OPEN;
        }
        if ("3".equals(jiraStatus)) {
            return IssueStatus.IN_PROGRESS;
        }
        if ("4".equals(jiraStatus)) {
            return IssueStatus.REOPENED;
        }
        if ("5".equals(jiraStatus)) {
            return IssueStatus.RESOLVED;
        }
        if ("6".equals(jiraStatus)) {
            return IssueStatus.CLOSED;
        }
        this.log("Uknown status code: " + jiraStatus);
        return IssueStatus.OPEN;
    }

    private User migrateUserIfRequired(String name) throws RemotePermissionException, RemoteAuthenticationException, java.rmi.RemoteException {
        RemoteUser remoteUser = this.jira.getUser(this.token, name);
        if (remoteUser == null && (remoteUser = this.lookupFromAllUsersList(name)) == null) {
            this.log("Warning: can't find user '" + name + "'");
            return null;
        }
        User user = this.tracker.getUser(remoteUser.getName());
        if (user == null) {
            user = this.tracker.createUser(remoteUser.getName(), remoteUser.getName(), remoteUser.getEmail(), remoteUser.getFullname());
        }
        return user;
    }

    private void log(String msg) {
        this.sb.append(msg);
        this.sb.append("\n");
    }

    public String getLog() {
        return this.sb.toString();
    }

    private RemoteUser lookupFromAllUsersList(String fullName) throws RemotePermissionException, RemoteValidationException, RemoteAuthenticationException, RemoteException, java.rmi.RemoteException {
        if (this.jiraUsers == null) {
            this.jiraUsers = this.jira.getGroup(this.token, "jira-users").getUsers();
        }
        for (RemoteUser remoteUser : this.jiraUsers) {
            if (!fullName.equals(remoteUser.getFullname())) continue;
            return remoteUser;
        }
        return null;
    }
}

