/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.Arrays;
import ua.com.softway.tracker.i18n.Resources;

public class IssueStatus {
    public static final IssueStatus OPEN = new IssueStatus("OPEN", 1);
    public static final IssueStatus IN_PROGRESS = new IssueStatus("IN_PROGRESS", 2);
    public static final IssueStatus REOPENED = new IssueStatus("REOPENED", 3);
    public static final IssueStatus RESOLVED = new IssueStatus("RESOLVED", 4);
    public static final IssueStatus CLOSED = new IssueStatus("CLOSED", 5);
    private int code;
    private String name;

    public static IssueStatus fromCode(String code) {
        int c = Integer.parseInt(code);
        if (c == 1) {
            return OPEN;
        }
        if (c == 2) {
            return IN_PROGRESS;
        }
        if (c == 3) {
            return REOPENED;
        }
        if (c == 4) {
            return RESOLVED;
        }
        if (c == 5) {
            return CLOSED;
        }
        throw new IllegalArgumentException("unknown IssueStatus code " + c);
    }

    public static IssueStatus[] openStatuses() {
        return new IssueStatus[]{OPEN, IN_PROGRESS, REOPENED};
    }

    private IssueStatus(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isOpen() {
        return Arrays.asList(IssueStatus.openStatuses()).contains(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueStatus that = (IssueStatus)o;
        return this.code == that.code;
    }

    public String name() {
        return this.name;
    }

    public String localizedName() {
        return Resources.getText("issueStatus." + this.name.toLowerCase());
    }

    public int hashCode() {
        return this.code;
    }

    public String toString() {
        return this.name;
    }
}

