/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.List;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueAttachment;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.IssueType;
import ua.com.softway.tracker.Priority;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;
import ua.com.softway.tracker.storage.StorageDateTimeFormat;
import ua.com.softway.tracker.worklog.Period;
import ua.com.softway.tracker.worklog.WorkLogItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IssueSerializer
implements Serializer<Issue> {
    private final Tracker tracker;
    private final Project project;

    public IssueSerializer(Tracker tracker, Project project) {
        this.tracker = tracker;
        this.project = project;
    }

    @Override
    public Issue load(ObjectUpdater<Issue> updater, Properties properties, String key) {
        User reporter = null;
        User assignee = null;
        if (properties.getProperty("reporter") != null) {
            reporter = this.tracker.getUser(properties.getProperty("reporter"));
        }
        if (properties.getProperty("assignee") != null) {
            assignee = this.tracker.getUser(properties.getProperty("assignee"));
        }
        Version affects = null;
        Version fix = null;
        if (properties.getProperty("affects") != null) {
            affects = this.project.getVersion(properties.getProperty("affects"));
        }
        if (properties.getProperty("fix") != null) {
            fix = this.project.getVersion(properties.getProperty("fix"));
        }
        Issue issue = new Issue(updater, this.project, key);
        issue.setSummary(properties.getProperty("summary"));
        issue.setDescription(properties.getProperty("description"));
        issue.setReporter(reporter);
        issue.setAssignee(assignee);
        issue.setStatus(IssueStatus.fromCode(properties.getProperty("status")));
        issue.setAffectsVersion(affects);
        issue.setFixVersion(fix);
        if (properties.getProperty("type") == null) {
            issue.setType(this.project.getDefaultIssueType());
        } else {
            IssueType issueType;
            block20: {
                issueType = IssueType.DEFECT;
                try {
                    issueType = IssueType.valueOf(properties.getProperty("type"));
                }
                catch (IllegalArgumentException e) {
                    int code = Integer.parseInt(properties.getProperty("type"));
                    if (code >= IssueType.values().length) break block20;
                    issueType = IssueType.values()[code];
                }
            }
            issue.setType(issueType);
        }
        if (properties.getProperty("priority") == null) {
            issue.setPriority(this.project.getDefaultPriority());
        } else {
            try {
                issue.setPriority(Priority.valueOf(properties.getProperty("priority")));
            }
            catch (IllegalArgumentException e) {
                issue.setPriority(Priority.IMPORTANT);
            }
        }
        if (properties.getProperty("resolution") != null) {
            issue.setResolution(this.project.getResolution(Integer.parseInt(properties.getProperty("resolution"))));
        }
        if (properties.getProperty("component") != null) {
            issue.setComponent(this.project.getComponent(properties.getProperty("component")));
        }
        if (properties.getProperty("estimate") != null) {
            issue.setEstimate(Period.fromExternalString(properties.getProperty("estimate")));
        }
        List<Properties> commentsProps = properties.getList("comments");
        for (Properties p : commentsProps) {
            User author = null;
            if (p.getProperty("author") != null) {
                author = this.tracker.getUser(p.getProperty("author"));
            }
            Comment comment = new Comment(p.getProperty("key"), author, p.getProperty("text"), StorageDateTimeFormat.parse(p.getProperty("posted")));
            issue.addComment(comment);
        }
        List<Properties> attachmentsProperties = properties.getList("attachments");
        for (Properties p : attachmentsProperties) {
            String name = p.getProperty("name");
            File file = this.tracker.getAttachmentFolder().getFile(p.getProperty("path"));
            String contentType = p.getProperty("contentType");
            int size = Integer.parseInt(p.getProperty("size"));
            issue.addAttachment(IssueAttachment.load(file, name, contentType, size));
        }
        List<Properties> watchersProperties = properties.getList("watchers");
        for (Properties p : watchersProperties) {
            String login = p.getProperty("login");
            User user = this.tracker.getUser(login);
            issue.getWatchers().add(user);
        }
        List<Properties> workLogProperties = properties.getList("workLog");
        for (Properties p : workLogProperties) {
            WorkLogItem item = new WorkLogItem();
            item.setUser(this.tracker.getUser(p.getProperty("user")));
            item.setPeriod(Period.fromExternalString(p.getProperty("period")));
            item.setBegin(StorageDateTimeFormat.parse(p.getProperty("begin")));
            issue.getWorkLog().add(item);
        }
        return issue;
    }

    @Override
    public void save(Properties properties, Issue issue) {
        properties.addProperty("summary", issue.getSummary());
        properties.addProperty("description", issue.getDescription());
        if (issue.getReporter() != null) {
            properties.addProperty("reporter", issue.getReporter().getLogin());
        }
        if (issue.getAssignee() != null) {
            properties.addProperty("assignee", issue.getAssignee().getLogin());
        }
        if (issue.getAffects() != null) {
            properties.addProperty("affects", issue.getAffects().getKey());
        }
        if (issue.getFix() != null) {
            properties.addProperty("fix", issue.getFix().getKey());
        }
        if (issue.getComponent() != null) {
            properties.addProperty("component", issue.getComponent().getKey());
        }
        properties.addProperty("status", String.valueOf(issue.getStatus().getCode()));
        properties.addProperty("priority", issue.getPriority().toString());
        properties.addProperty("type", issue.getType().name());
        if (issue.getResolution() != null) {
            properties.addProperty("resolution", String.valueOf(issue.getResolution().getCode()));
        }
        if (issue.getEstimate() != null) {
            properties.addProperty("estimate", issue.getEstimate().toExternalString());
        }
        List<Properties> commentsProperties = properties.addList("comments", "comment");
        for (Comment comment : issue.getComments()) {
            Properties p = new Properties();
            p.addProperty("key", comment.getKey());
            if (comment.getAuthor() != null) {
                p.addProperty("author", comment.getAuthor().getLogin());
            }
            p.addProperty("text", comment.getText());
            p.addProperty("posted", StorageDateTimeFormat.format(comment.getPostedDate()));
            commentsProperties.add(p);
        }
        List<Properties> attachmentProperties = properties.addList("attachments", "attachment");
        for (IssueAttachment attachment : issue.getAttachments()) {
            Properties p = new Properties();
            p.addProperty("name", attachment.getName());
            p.addProperty("contentType", attachment.getContentType());
            p.addProperty("size", "" + attachment.getSize());
            p.addProperty("path", attachment.getPath());
            attachmentProperties.add(p);
        }
        List<Properties> watchersProperties = properties.addList("watchers", "watcher");
        for (User user : issue.getWatchers()) {
            Properties p = new Properties();
            p.addProperty("login", user.getLogin());
            watchersProperties.add(p);
        }
        List<Properties> workLogProperties = properties.addList("workLog", "item");
        for (WorkLogItem item : issue.getWorkLog().getItems()) {
            Properties p = new Properties();
            p.addProperty("user", item.getUser().getLogin());
            p.addProperty("period", item.getPeriod().toExternalString());
            p.addProperty("begin", StorageDateTimeFormat.format(item.getBegin()));
            workLogProperties.add(p);
        }
    }

    @Override
    public String getKey(Issue issue) {
        return issue.getKey();
    }
}

