/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.Iterator;
import java.util.List;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.IssueType;
import ua.com.softway.tracker.Priority;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueMatcher {
    public static final String ANY = "*";
    public static final String NONE = "-";
    private Tracker tracker;
    private String project;
    private String reporter = "*";
    private String assignee = "*";
    private String affects = "*";
    private String fix = "*";
    private String text = "";
    private String status = "*";
    private String priority = "*";
    private String issueType = "*";
    private String component = "*";

    public IssueMatcher(Tracker tracker, String project) {
        if (tracker == null) {
            throw new IllegalArgumentException("tracker==null");
        }
        if (tracker.getProject(project) == null) {
            new IllegalStateException("no project with key=" + this.project);
        }
        this.tracker = tracker;
        this.project = project;
    }

    public List<Issue> getMatchedIssues() {
        List<Issue> issues = this.tracker.getVisibleIssues();
        Iterator<Issue> i = issues.iterator();
        while (i.hasNext()) {
            if (this.matches(i.next())) continue;
            i.remove();
        }
        return issues;
    }

    public boolean matches(Issue issue) {
        Project project = this.tracker.getProject(this.project);
        if (!issue.getProject().equals(project)) {
            return false;
        }
        if (!this.matchesReporter(issue)) {
            return false;
        }
        if (!this.matchesAssignee(issue)) {
            return false;
        }
        if (!this.matchesAffects(issue)) {
            return false;
        }
        if (!this.matchesFix(issue)) {
            return false;
        }
        if (!this.matchesStatus(issue)) {
            return false;
        }
        if (!this.matchesPriority(issue)) {
            return false;
        }
        if (!this.matchesText(issue)) {
            return false;
        }
        if (!this.matchesIssueType(issue)) {
            return false;
        }
        return this.matchesComponent(issue);
    }

    private boolean matchesReporter(Issue issue) {
        if (ANY.equals(this.reporter)) {
            return true;
        }
        if (NONE.equals(this.reporter)) {
            return issue.getReporter() == null;
        }
        if (this.tracker.getUser(this.reporter) == null) {
            return true;
        }
        if (issue.getReporter() == null) {
            return false;
        }
        return this.reporter.equals(issue.getReporter().getLogin());
    }

    private boolean matchesAssignee(Issue issue) {
        if (ANY.equals(this.assignee)) {
            return true;
        }
        if (NONE.equals(this.assignee)) {
            return issue.getAssignee() == null;
        }
        if (this.tracker.getUser(this.assignee) == null) {
            return true;
        }
        if (issue.getAssignee() == null) {
            return false;
        }
        return this.assignee.equals(issue.getAssignee().getLogin());
    }

    private boolean matchesAffects(Issue issue) {
        if (ANY.equals(this.affects)) {
            return true;
        }
        if (NONE.equals(this.affects)) {
            return issue.getAffects() == null;
        }
        if (issue.getProject().getVersion(this.affects) == null) {
            return true;
        }
        if (issue.getAffects() == null) {
            return false;
        }
        return this.affects.equals(issue.getAffects().getKey());
    }

    private boolean matchesFix(Issue issue) {
        if (ANY.equals(this.fix)) {
            return true;
        }
        if (NONE.equals(this.fix)) {
            return issue.getFix() == null;
        }
        if (issue.getProject().getVersion(this.fix) == null) {
            return true;
        }
        if (issue.getFix() == null) {
            return false;
        }
        return this.fix.equals(issue.getFix().getKey());
    }

    private boolean matchesPriority(Issue issue) {
        if (ANY.equals(this.priority)) {
            return true;
        }
        try {
            Priority requiredPriority = Priority.valueOf(this.priority);
            return requiredPriority.equals((Object)issue.getPriority());
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    private boolean matchesIssueType(Issue issue) {
        if (ANY.equals(this.issueType)) {
            return true;
        }
        try {
            IssueType requiredIssueType = IssueType.valueOf(this.issueType);
            return requiredIssueType.equals((Object)issue.getType());
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    private boolean matchesText(Issue issue) {
        if (this.text == null || this.text.equals("")) {
            return true;
        }
        this.text = this.text.toLowerCase();
        boolean inDescription = issue.getDescription() != null && issue.getDescription().toLowerCase().contains(this.text);
        boolean inSummary = issue.getSummary().toLowerCase().contains(this.text);
        return inDescription || inSummary;
    }

    private boolean matchesStatus(Issue issue) {
        String[] statuses;
        if (ANY.equals(this.status)) {
            return true;
        }
        for (String singleStatus : statuses = this.status.split(",")) {
            if (!issue.getStatus().equals(IssueStatus.fromCode(singleStatus))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesComponent(Issue issue) {
        if (ANY.equals(this.component)) {
            return true;
        }
        if (NONE.equals(this.component)) {
            return issue.getComponent() == null;
        }
        if (issue.getComponent() == null) {
            return false;
        }
        return issue.getComponent().getKey().equals(this.component);
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getAffects() {
        return this.affects;
    }

    public void setAffects(String affects) {
        this.affects = affects;
    }

    public String getFix() {
        return this.fix;
    }

    public void setFix(String fix) {
        this.fix = fix;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatuses(IssueStatus ... statuses) {
        this.status = IssueMatcher.statusExpression(statuses);
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getComponent() {
        return this.component;
    }

    public static String statusExpression(IssueStatus ... statuses) {
        String statusExpression = "";
        for (int i = 0; i < statuses.length; ++i) {
            IssueStatus issueStatus = statuses[i];
            statusExpression = statusExpression + issueStatus.getCode();
            if (i >= statuses.length - 1) continue;
            statusExpression = statusExpression + ",";
        }
        return statusExpression;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public String getIssueType() {
        return this.issueType;
    }
}

