/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import ua.com.softway.tracker.Direction;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueMatcher;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.storage.Keys;

public class IssueFilter {
    private String key;
    private String name;
    private String project;
    private String reporter = "*";
    private String assignee = "*";
    private String status = "*";
    private String affects = "*";
    private String fix = "*";
    private String priority = "*";
    private String issueType = "*";
    private String component = "*";
    private String text = "";
    private IssueField comparator = IssueField.KEY;
    private Direction direction = Direction.ASC;

    public IssueFilter(String project) {
        this(Keys.getNextKey(), project);
    }

    public IssueFilter(String key, String project) {
        this.key = key;
        this.project = project;
        this.name = "filter " + key;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProject() {
        return this.project;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAffects() {
        return this.affects;
    }

    public void setAffects(String affects) {
        this.affects = affects;
    }

    public String getFix() {
        return this.fix;
    }

    public void setFix(String fix) {
        this.fix = fix;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setComparator(IssueField comparator) {
        this.comparator = comparator;
    }

    public IssueField getComparator() {
        return this.comparator;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public IssueMatcher getMatcher() {
        IssueMatcher matcher = new IssueMatcher(Tracker.instance(), this.project);
        matcher.setAffects(this.affects);
        matcher.setAssignee(this.assignee);
        matcher.setFix(this.fix);
        matcher.setIssueType(this.issueType);
        matcher.setPriority(this.priority);
        matcher.setReporter(this.reporter);
        matcher.setStatus(this.status);
        matcher.setComponent(this.component);
        matcher.setText(this.text);
        return matcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IssueFilter)) {
            return false;
        }
        IssueFilter that = (IssueFilter)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "IssueFilter{ " + this.name + "}";
    }
}

