/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.Comparator;
import java.util.Date;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Priority;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.util.InvalidIssueKeyException;
import ua.com.softway.tracker.util.IssueKey;
import ua.com.softway.tracker.util.Objects;
import ua.com.softway.tracker.util.XmlEscaper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IssueField implements Comparator<Issue>
{
    KEY{

        public int compare(Issue left, Issue right) {
            try {
                IssueKey leftKey = new IssueKey(left.getKey());
                IssueKey rightKey = new IssueKey(right.getKey());
                return leftKey.getIssueIndex() - rightKey.getIssueIndex();
            }
            catch (InvalidIssueKeyException e) {
                throw new RuntimeException(e);
            }
        }

        public String getValue(Issue issue) {
            return issue.getKey();
        }

        public String getHtmlValue(Issue issue) {
            return "<a href='" + Pages.viewIssue(issue.getKey()) + "'>" + issue.getKey() + "</a>";
        }
    }
    ,
    TYPE{

        public int compare(Issue left, Issue right) {
            return left.getType().compareTo(right.getType());
        }

        public String getValue(Issue issue) {
            return issue.getType().localizedName();
        }

        public String getHtmlValue(Issue issue) {
            return "<img src='/img/issue_type/" + issue.getType().name().toLowerCase() + ".gif'/>";
        }
    }
    ,
    SUMMARY{

        public int compare(Issue left, Issue right) {
            return left.getSummary().compareTo(right.getSummary());
        }

        public String getValue(Issue issue) {
            return issue.getSummary();
        }

        public String getHtmlValue(Issue issue) {
            return "<a class='black' href='" + Pages.viewIssue(issue.getKey()) + "'>" + XmlEscaper.escape(issue.getSummary()) + "</a>";
        }
    }
    ,
    REPORTER{

        public int compare(Issue left, Issue right) {
            return Objects.compare(left.getReporter(), right.getReporter());
        }

        public String getValue(Issue issue) {
            User reporter = issue.getReporter();
            if (reporter != null) {
                return reporter.getName();
            }
            return "-";
        }
    }
    ,
    ASSIGNEE{

        public int compare(Issue left, Issue right) {
            return Objects.compare(left.getAssignee(), right.getAssignee());
        }

        public String getValue(Issue issue) {
            User assignee = issue.getAssignee();
            if (assignee != null) {
                return assignee.getName();
            }
            return "-";
        }
    }
    ,
    FIX{

        public int compare(Issue left, Issue right) {
            return Objects.compare(left.getFix(), right.getFix(), new VersionNameComparator());
        }

        public String getValue(Issue issue) {
            Version fix = issue.getFix();
            if (fix != null) {
                return fix.getName();
            }
            return "-";
        }
    }
    ,
    AFFECTS{

        public int compare(Issue left, Issue right) {
            return Objects.compare(left.getAffects(), right.getAffects(), new VersionNameComparator());
        }

        public String getValue(Issue issue) {
            Version affects = issue.getAffects();
            if (affects != null) {
                return affects.getName();
            }
            return "-";
        }
    }
    ,
    COMPONENT{

        public int compare(Issue left, Issue right) {
            return Objects.compare(left.getComponent(), right.getComponent());
        }

        public String getValue(Issue issue) {
            Component component = issue.getComponent();
            if (component != null) {
                return component.getName();
            }
            return "-";
        }
    }
    ,
    STATUS{

        public int compare(Issue left, Issue right) {
            return left.getStatus().getCode() - right.getStatus().getCode();
        }

        public String getValue(Issue issue) {
            return issue.getStatus().localizedName();
        }

        public String getHtmlValue(Issue issue) {
            IssueStatus status = issue.getStatus();
            String html = "<table border='0' cellpadding='0' cellspacing='0'><tr>";
            html = html + "<td><img src='/img/issue_status/new/" + status.name().toLowerCase() + ".gif'/></td>";
            html = html + "<td class='text' nowrap style='color:gray; padding-left:4px;'>" + status.localizedName() + "</td>";
            html = html + "</tr></table>";
            return html;
        }
    }
    ,
    ESTIMATE{

        public int compare(Issue left, Issue right) {
            return Objects.compare(left.getEstimate(), right.getEstimate());
        }

        public String getValue(Issue issue) {
            if (issue.getEstimate() == null) {
                return "-";
            }
            return issue.getEstimate().toLocalString();
        }
    }
    ,
    LOGGED_WORK{

        public int compare(Issue left, Issue right) {
            return Objects.compare(left.getWorkLog().getTimeSpent(), right.getWorkLog().getTimeSpent());
        }

        public String getValue(Issue issue) {
            return issue.getWorkLog().getTimeSpent().toLocalString();
        }
    }
    ,
    PRIORITY{

        public int compare(Issue left, Issue right) {
            return left.getPriority().compareTo(right.getPriority());
        }

        public String getValue(Issue issue) {
            return issue.getPriority().localizedName();
        }

        public String getHtmlValue(Issue issue) {
            Priority priority = issue.getPriority();
            String html = "<table border='0' cellpadding='0' cellspacing='0'><tr>";
            html = html + "<td><img src='/img/priority/" + priority.name().toLowerCase() + ".gif'/></td>";
            html = html + "<td class='text' nowrap style='color:gray; padding-left:4px;'>" + priority.localizedName() + "</td>";
            html = html + "</tr></table>";
            return html;
        }
    }
    ,
    CREATED{

        public String getValue(Issue issue) {
            if (issue.getCreated().equals(new Date(0L))) {
                return "-";
            }
            return User.currentUser().getDateFormat().formatDateTime(issue.getCreated());
        }

        public int compare(Issue left, Issue right) {
            return left.getCreated().compareTo(right.getCreated());
        }
    }
    ,
    UPDATED{

        public String getValue(Issue issue) {
            if (issue.getUpdated().equals(new Date(0L))) {
                return "-";
            }
            return User.currentUser().getDateFormat().formatDateTime(issue.getUpdated());
        }

        public int compare(Issue left, Issue right) {
            return left.getUpdated().compareTo(right.getUpdated());
        }
    };


    public String localizedName() {
        return Resources.getText("issueField." + this.name().toLowerCase());
    }

    public abstract String getValue(Issue var1);

    public String getHtmlValue(Issue issue) {
        return this.getValue(issue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VersionNameComparator
    implements Comparator<Version> {
        private VersionNameComparator() {
        }

        @Override
        public int compare(Version left, Version right) {
            return left.getName().compareTo(right.getName());
        }
    }
}

