/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.util.StreamPump;

public class IssueAttachment {
    private String contentType;
    private int size;
    private String name;
    private File file;

    private IssueAttachment(File file, String name, String contentType, int size) {
        this.name = name;
        this.file = file;
        this.contentType = contentType;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        return this.file.openInputStream();
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getSize() {
        return this.size;
    }

    protected String getPath() {
        return this.file.getName();
    }

    protected void delete() {
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    protected static IssueAttachment save(File file, InputStream source, String name, String contentType, int size) {
        try {
            OutputStream target = file.openOutputStream();
            StreamPump.pumpAndClose(source, target);
            return new IssueAttachment(file, name, contentType, size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static IssueAttachment load(File file, String name, String contentType, int size) {
        return new IssueAttachment(file, name, contentType, size);
    }
}

