/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.IssueAttachment;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.IssueType;
import ua.com.softway.tracker.Priority;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Resolution;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.storage.Keys;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.worklog.Period;
import ua.com.softway.tracker.worklog.WorkLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Issue {
    private final Project project;
    private final String key;
    private String summary;
    private User assignee;
    private User reporter;
    private String description;
    private IssueStatus status;
    private Version fix;
    private Version affects;
    private IssueType type;
    private Priority priority;
    private Period estimate;
    private Resolution resolution;
    private Component component;
    private final List<Comment> comments = new ArrayList<Comment>();
    private final List<IssueAttachment> attachments = new ArrayList<IssueAttachment>();
    private final Set<User> watchers = new HashSet<User>();
    private final WorkLog workLog = new WorkLog();
    private final ObjectUpdater<Issue> updater;

    Issue(ObjectUpdater<Issue> updater, Project project, String key) {
        this.updater = updater;
        this.project = project;
        this.key = key;
        this.summary = "null-summary";
        this.description = "null-description";
        this.status = IssueStatus.OPEN;
        this.priority = Priority.IMPORTANT;
        this.type = IssueType.FEAUTURE;
    }

    public Project getProject() {
        return this.project;
    }

    public String getKey() {
        return this.key;
    }

    public User getAssignee() {
        return this.assignee;
    }

    public String getDescription() {
        return this.description;
    }

    public User getReporter() {
        return this.reporter;
    }

    public String getSummary() {
        return this.summary;
    }

    public IssueStatus getStatus() {
        return this.status;
    }

    public Version getFix() {
        return this.fix;
    }

    public Version getAffects() {
        return this.affects;
    }

    public Period getEstimate() {
        return this.estimate;
    }

    void setStatus(IssueStatus status) {
        this.status = status;
    }

    public void setFixVersion(Version fix) {
        this.fix = fix;
    }

    public void setAffectsVersion(Version affects) {
        this.affects = affects;
    }

    public void setAssignee(User assigne) {
        this.assignee = assigne;
    }

    public void setReporter(User reportedBy) {
        this.reporter = reportedBy;
    }

    public void setSummary(String summary) {
        if (summary == null) {
            throw new IllegalArgumentException("summary==null");
        }
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEstimate(Period estimate) {
        this.estimate = estimate;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public IssueType getType() {
        return this.type;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void store() {
        this.updater.saveOrUpdate(this);
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public void deleteComment(String commentKey) {
        Iterator<Comment> i = this.comments.iterator();
        while (i.hasNext()) {
            Comment comment = i.next();
            if (!comment.getKey().equals(commentKey)) continue;
            i.remove();
        }
    }

    public Comment getComment(String commentKey) {
        for (Comment comment : this.comments) {
            if (!comment.getKey().equals(commentKey)) continue;
            return comment;
        }
        return null;
    }

    public List<IssueEvent> getEvents() {
        return this.getProject().getTracker().getEventRecorder().getEvents(this);
    }

    public Date getUpdated() {
        List<IssueEvent> events = this.getEvents();
        if (events.isEmpty()) {
            return new Date(0L);
        }
        return events.get(0).getDate();
    }

    public Date getCreated() {
        List<IssueEvent> events = this.getEvents();
        if (events.isEmpty()) {
            return new Date(0L);
        }
        return events.get(events.size() - 1).getDate();
    }

    protected void addAttachment(IssueAttachment attachment) {
        this.attachments.add(attachment);
    }

    public IssueAttachment addAttachment(InputStream source, String name, String contentType, int size) {
        File file = this.project.getTracker().getAttachmentFolder().getFile(this.key + "." + Keys.getNextKey());
        IssueAttachment attachment = IssueAttachment.save(file, source, name, contentType, size);
        this.attachments.add(attachment);
        return attachment;
    }

    public List<IssueAttachment> getAttachments() {
        return new ArrayList<IssueAttachment>(this.attachments);
    }

    public IssueAttachment getAttachment(String name) {
        for (IssueAttachment attachment : this.attachments) {
            if (!attachment.getName().equals(name)) continue;
            return attachment;
        }
        return null;
    }

    public void deleteAttachment(String name) {
        Iterator<IssueAttachment> iterator = this.attachments.iterator();
        while (iterator.hasNext()) {
            IssueAttachment attachment = iterator.next();
            if (!attachment.getName().equals(name)) continue;
            iterator.remove();
            attachment.delete();
        }
    }

    public Set<User> getWatchers() {
        return this.watchers;
    }

    public WorkLog getWorkLog() {
        return this.workLog;
    }
}

