/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.HashSet;
import java.util.List;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupSerializer
implements Serializer<Group> {
    private final Tracker tracker;

    public GroupSerializer(Tracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public Group load(ObjectUpdater<Group> updater, Properties properties, String key) {
        HashSet<User> users = new HashSet<User>();
        String name = properties.getProperty("name");
        Group group = new Group(key, updater, name, users);
        List<Properties> usersProps = properties.getList("users");
        for (Properties p : usersProps) {
            User user = null;
            if (p.getProperty("name") != null) {
                user = this.tracker.getUser(p.getProperty("name"));
            }
            if (user == null) continue;
            users.add(user);
        }
        return group;
    }

    @Override
    public void save(Properties properties, Group object) {
        properties.addProperty("name", object.getName());
        List<Properties> usersProperties = properties.addList("users", "user");
        for (User user : object.getUsers()) {
            Properties p = new Properties();
            p.addProperty("name", user.getLogin());
            usersProperties.add(p);
        }
    }

    @Override
    public String getKey(Group object) {
        return object.getKey();
    }
}

