/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.util.Iterator;
import java.util.Set;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.storage.ObjectUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
implements Comparable<Group> {
    public static final String ADMINISTRATORS = "administrators";
    public static final String USERS = "users";
    private final String key;
    private String name;
    private final Set<User> users;
    private final ObjectUpdater<Group> updater;

    public Group(String key, ObjectUpdater<Group> updater, String name, Set<User> users) {
        this.key = key;
        this.updater = updater;
        this.name = name;
        this.users = users;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public void store() {
        this.updater.saveOrUpdate(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeUser(String userName) {
        Iterator<User> i = this.users.iterator();
        while (i.hasNext()) {
            if (!i.next().getLogin().equals(userName)) continue;
            i.remove();
        }
    }

    public boolean containsUser(User user) {
        return this.users.contains(user);
    }

    public boolean isSystem() {
        return ADMINISTRATORS.equals(this.name) || USERS.equals(this.name);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            Group that = (Group)obj;
            return this.getKey().equals(that.getKey());
        }
        return false;
    }

    @Override
    public int compareTo(Group o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "Group{" + this.name + "}";
    }
}

