/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormat {
    private static final String DAY_PATTERN = "EEE, MMM d, yyyy";
    private String datePattern;
    private String timePattern;
    private SimpleDateFormat dateTimeFormat;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dayFormat;
    private SimpleDateFormat timeFormat;

    public DateFormat() {
        this.setPatterns("dd.MM.yyyy", "HH:mm", "en");
    }

    public void setPatterns(String datePattern, String timePattern, String language) {
        this.datePattern = datePattern;
        this.timePattern = timePattern;
        this.dateFormat = new SimpleDateFormat(datePattern);
        this.dateFormat.setLenient(false);
        this.timeFormat = new SimpleDateFormat(timePattern);
        this.timeFormat.setLenient(false);
        this.dateTimeFormat = new SimpleDateFormat(datePattern + " " + timePattern);
        this.dateTimeFormat.setLenient(false);
        this.dayFormat = new SimpleDateFormat(DAY_PATTERN, new Locale(language));
        this.dayFormat.setLenient(false);
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getLocalizedDatePattern() {
        return this.localizePattern(this.datePattern);
    }

    public String getTimePattern() {
        return this.timePattern;
    }

    public String getLocalizedTimePattern() {
        return this.localizePattern(this.timePattern);
    }

    public String getDateTimePattern() {
        return this.datePattern + " " + this.timePattern;
    }

    public String getDayPattern() {
        return DAY_PATTERN;
    }

    public List<String> getSupportedDatePatterns() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("dd.MM.yyyy");
        result.add("yyyy-MM-dd");
        result.add("MM/dd/yyyy");
        result.add("dd/MM/yyyy");
        return result;
    }

    public List<String> getSupportedTimePatterns() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HH:mm");
        result.add("hh:mm aaa");
        return result;
    }

    public String localizePattern(String pattern) {
        return Resources.getText("dateFormat." + pattern);
    }

    public String formatDay(Date date) {
        if (date == null) {
            return "";
        }
        return this.dayFormat.format(date);
    }

    public String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        return this.dateTimeFormat.format(date);
    }

    public String formatTime(Date date) {
        if (date == null) {
            return "";
        }
        return this.timeFormat.format(date);
    }

    public String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return this.dateFormat.format(date);
    }

    public Date parseDate(String date) {
        if (Strings.isBlank(date)) {
            return null;
        }
        try {
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isValidDate(String date) {
        if (Strings.isBlank(date)) {
            return true;
        }
        try {
            this.dateFormat.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

