/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.util.ArrayIterator;
import org.apache.velocity.util.EnumerationIterator;

public class IteratorTool
implements Iterator {
    private Object wrapped;
    private Iterator iterator;
    private boolean wantMore;
    private boolean cachedNext;
    protected Object next;

    public IteratorTool() {
        this(null);
    }

    public IteratorTool(Object object) {
        this.internalWrap(object);
    }

    public IteratorTool wrap(Object object) {
        if (this.wrapped == null) {
            return new IteratorTool(object);
        }
        if (object != null) {
            this.internalWrap(object);
            return this;
        }
        throw new IllegalArgumentException("Need a valid list to wrap");
    }

    private void internalWrap(Object object) {
        if (object != null) {
            if (object.getClass().isArray()) {
                this.iterator = new ArrayIterator((Object[])object);
            } else if (object instanceof Collection) {
                this.iterator = ((Collection)object).iterator();
            } else if (object instanceof Map) {
                this.iterator = ((Map)object).values().iterator();
            } else if (object instanceof Iterator) {
                this.iterator = (Iterator)object;
            } else if (object instanceof Enumeration) {
                this.iterator = new EnumerationIterator((Enumeration)object);
            } else {
                throw new IllegalArgumentException("Don't know how to wrap this list");
            }
            this.wrapped = object;
            this.wantMore = true;
            this.cachedNext = false;
        } else {
            this.iterator = null;
            this.wrapped = null;
            this.wantMore = false;
            this.cachedNext = false;
        }
    }

    public void reset() {
        if (this.wrapped != null) {
            this.internalWrap(this.wrapped);
        }
    }

    public Object next() {
        if (this.wrapped == null) {
            throw new IllegalStateException("Use wrap() before calling next()");
        }
        if (!this.cachedNext) {
            this.cachedNext = true;
            this.next = this.iterator.next();
            return this.next;
        }
        return this.next;
    }

    public boolean hasNext() {
        if (this.wantMore) {
            this.wantMore = false;
            return this.hasMore();
        }
        this.wantMore = true;
        return false;
    }

    public void remove() throws UnsupportedOperationException {
        if (this.wrapped == null) {
            throw new IllegalStateException("Use wrap() before calling remove()");
        }
        this.iterator.remove();
    }

    public Object more() {
        this.wantMore = true;
        if (this.hasMore()) {
            Object object = this.next();
            this.cachedNext = false;
            return object;
        }
        return null;
    }

    public boolean hasMore() {
        if (this.wrapped == null) {
            return false;
        }
        return this.cachedNext || this.iterator.hasNext();
    }

    public void stop() {
        this.wantMore = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        if (this.wrapped != null) {
            stringBuffer.append('(');
            stringBuffer.append(this.wrapped);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }
}

