/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import ognl.Evaluation;
import ognl.InappropriateExpressionException;
import ognl.Node;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.OgnlParserTreeConstants;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected OgnlParser parser;

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        int n = 0;
        if (this.children != null) {
            n = this.children.length;
        }
        return n;
    }

    public String toString() {
        return OgnlParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + OgnlParserTreeConstants.jjtNodeName[this.id] + ' ' + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(prefix + "  ");
                }
                ++i;
            }
        }
    }

    private static final String getDepthString(int depth) {
        StringBuffer result = new StringBuffer("");
        while (depth > 0) {
            --depth;
            result.append("  ");
        }
        return new String(result);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getValue(OgnlContext context, Object source) throws OgnlException {
        Object result = null;
        OgnlException evalException = null;
        context.pushEvaluation(new Evaluation(this, source));
        try {
            try {
                if (source != null) {
                    context.setCurrentObject(source);
                }
                result = this.getValueBody(context, source);
            }
            catch (OgnlException ex) {
                evalException = ex;
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Evaluation eval = context.popEvaluation();
            eval.setResult(result);
            eval.setException(evalException);
            throw throwable;
        }
        {
            Object var6_8 = null;
            Evaluation eval = context.popEvaluation();
            eval.setResult(result);
            eval.setException(evalException);
            return result;
        }
    }

    protected abstract Object getValueBody(OgnlContext var1, Object var2) throws OgnlException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setValue(OgnlContext context, Object target, Object value) throws OgnlException {
        context.pushEvaluation(new Evaluation(this, target, true));
        try {
            if (target != null) {
                context.setCurrentObject(target);
            }
            this.setValueBody(context, target, value);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.popEvaluation();
            throw throwable;
        }
        {
            Object var5_6 = null;
            context.popEvaluation();
        }
    }

    protected void setValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        throw new InappropriateExpressionException(this);
    }

    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isConstant(OgnlContext context) throws OgnlException {
        return this.isNodeConstant(context);
    }

    public boolean isNodeSimpleProperty(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isSimpleProperty(OgnlContext context) throws OgnlException {
        return this.isNodeSimpleProperty(context);
    }

    public boolean isSimpleNavigationChain(OgnlContext context) throws OgnlException {
        return this.isSimpleProperty(context);
    }

    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += this.children[i].jjtGetNumChildren();
            } else {
                ++newSize;
            }
            ++i;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            int i2 = 0;
            while (i2 < this.children.length) {
                Node c = this.children[i2];
                if (c.getClass() == this.getClass()) {
                    int k = 0;
                    while (k < c.jjtGetNumChildren()) {
                        newChildren[j++] = c.jjtGetChild(k);
                        ++k;
                    }
                } else {
                    newChildren[j++] = c;
                }
                ++i2;
            }
            if (j != newSize) {
                throw new Error("Assertion error: " + j + " != " + newSize);
            }
            this.children = newChildren;
        }
    }

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(OgnlParser p, int i) {
        this(i);
        this.parser = p;
    }
}

