/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import ognl.ElementsAccessor;
import ognl.NumericTypes;
import ognl.OgnlException;
import ognl.OgnlRuntime;

public abstract class OgnlOps
implements NumericTypes {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean booleanValue(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> c = value.getClass();
        Class clazz = class$java$lang$Boolean;
        if (clazz == null) {
            clazz = class$java$lang$Boolean = OgnlOps.class$("[Ljava.lang.Boolean;", false);
        }
        if (c == clazz) {
            return (Boolean)value;
        }
        Class clazz2 = class$java$lang$Character;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Character = OgnlOps.class$("[Ljava.lang.Character;", false);
        }
        if (c == clazz2) {
            boolean bl = false;
            if (((Character)value).charValue() != '\u0000') {
                bl = true;
            }
            return bl;
        }
        if (value instanceof Number) {
            boolean bl = false;
            if (((Number)value).doubleValue() != 0.0) {
                bl = true;
            }
            return bl;
        }
        return true;
    }

    public static long longValue(Object value) {
        Class<?> c = value.getClass();
        Class<?> clazz = c.getSuperclass();
        Class clazz2 = class$java$lang$Number;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Number = OgnlOps.class$("[Ljava.lang.Number;", false);
        }
        if (clazz == clazz2) {
            return ((Number)value).longValue();
        }
        Class clazz3 = class$java$lang$Character;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Character = OgnlOps.class$("[Ljava.lang.Character;", false);
        }
        if (c == clazz3) {
            return ((Character)value).charValue();
        }
        Class clazz4 = class$java$lang$Boolean;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Boolean = OgnlOps.class$("[Ljava.lang.Boolean;", false);
        }
        if (c == clazz4) {
            return (long)((Boolean)value).booleanValue();
        }
        return Long.parseLong(value.toString());
    }

    public static double doubleValue(Object value) {
        Class<?> c = value.getClass();
        Class<?> clazz = c.getSuperclass();
        Class clazz2 = class$java$lang$Number;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Number = OgnlOps.class$("[Ljava.lang.Number;", false);
        }
        if (clazz == clazz2) {
            return ((Number)value).doubleValue();
        }
        Class clazz3 = class$java$lang$Character;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Character = OgnlOps.class$("[Ljava.lang.Character;", false);
        }
        if (c == clazz3) {
            return ((Character)value).charValue();
        }
        Class clazz4 = class$java$lang$Boolean;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Boolean = OgnlOps.class$("[Ljava.lang.Boolean;", false);
        }
        if (c == clazz4) {
            return (double)((Boolean)value).booleanValue();
        }
        return Double.parseDouble(value.toString());
    }

    public static BigInteger bigIntValue(Object value) {
        Class<?> c = value.getClass();
        Class clazz = class$java$math$BigInteger;
        if (clazz == null) {
            clazz = class$java$math$BigInteger = OgnlOps.class$("[Ljava.math.BigInteger;", false);
        }
        if (c == clazz) {
            return (BigInteger)value;
        }
        Class clazz2 = class$java$math$BigDecimal;
        if (clazz2 == null) {
            clazz2 = class$java$math$BigDecimal = OgnlOps.class$("[Ljava.math.BigDecimal;", false);
        }
        if (c == clazz2) {
            return ((BigDecimal)value).toBigInteger();
        }
        Class<?> clazz3 = c.getSuperclass();
        Class clazz4 = class$java$lang$Number;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Number = OgnlOps.class$("[Ljava.lang.Number;", false);
        }
        if (clazz3 == clazz4) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        Class clazz5 = class$java$lang$Character;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Character = OgnlOps.class$("[Ljava.lang.Character;", false);
        }
        if (c == clazz5) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        Class clazz6 = class$java$lang$Boolean;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Boolean = OgnlOps.class$("[Ljava.lang.Boolean;", false);
        }
        if (c == clazz6) {
            return BigInteger.valueOf((long)((Boolean)value).booleanValue());
        }
        return new BigInteger(value.toString());
    }

    public static BigDecimal bigDecValue(Object value) {
        Class<?> c = value.getClass();
        Class clazz = class$java$math$BigDecimal;
        if (clazz == null) {
            clazz = class$java$math$BigDecimal = OgnlOps.class$("[Ljava.math.BigDecimal;", false);
        }
        if (c == clazz) {
            return (BigDecimal)value;
        }
        Class clazz2 = class$java$math$BigInteger;
        if (clazz2 == null) {
            clazz2 = class$java$math$BigInteger = OgnlOps.class$("[Ljava.math.BigInteger;", false);
        }
        if (c == clazz2) {
            return new BigDecimal((BigInteger)value);
        }
        Class<?> clazz3 = c.getSuperclass();
        Class clazz4 = class$java$lang$Number;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Number = OgnlOps.class$("[Ljava.lang.Number;", false);
        }
        if (clazz3 == clazz4) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        Class clazz5 = class$java$lang$Character;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Character = OgnlOps.class$("[Ljava.lang.Character;", false);
        }
        if (c == clazz5) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        Class clazz6 = class$java$lang$Boolean;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Boolean = OgnlOps.class$("[Ljava.lang.Boolean;", false);
        }
        if (c == clazz6) {
            return BigDecimal.valueOf((long)((Boolean)value).booleanValue());
        }
        return new BigDecimal(value.toString());
    }

    public static int getNumericType(Object value) {
        Class<?> c = value.getClass();
        Class clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = OgnlOps.class$("[Ljava.lang.Integer;", false);
        }
        if (c == clazz) {
            return 4;
        }
        Class clazz2 = class$java$lang$Double;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Double = OgnlOps.class$("[Ljava.lang.Double;", false);
        }
        if (c == clazz2) {
            return 8;
        }
        Class clazz3 = class$java$lang$Boolean;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Boolean = OgnlOps.class$("[Ljava.lang.Boolean;", false);
        }
        if (c == clazz3) {
            return 0;
        }
        Class clazz4 = class$java$lang$Byte;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Byte = OgnlOps.class$("[Ljava.lang.Byte;", false);
        }
        if (c == clazz4) {
            return 1;
        }
        Class clazz5 = class$java$lang$Character;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Character = OgnlOps.class$("[Ljava.lang.Character;", false);
        }
        if (c == clazz5) {
            return 2;
        }
        Class clazz6 = class$java$lang$Short;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Short = OgnlOps.class$("[Ljava.lang.Short;", false);
        }
        if (c == clazz6) {
            return 3;
        }
        Class clazz7 = class$java$lang$Long;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Long = OgnlOps.class$("[Ljava.lang.Long;", false);
        }
        if (c == clazz7) {
            return 5;
        }
        Class clazz8 = class$java$lang$Float;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Float = OgnlOps.class$("[Ljava.lang.Float;", false);
        }
        if (c == clazz8) {
            return 7;
        }
        Class clazz9 = class$java$math$BigInteger;
        if (clazz9 == null) {
            clazz9 = class$java$math$BigInteger = OgnlOps.class$("[Ljava.math.BigInteger;", false);
        }
        if (c == clazz9) {
            return 6;
        }
        Class clazz10 = class$java$math$BigDecimal;
        if (clazz10 == null) {
            clazz10 = class$java$math$BigDecimal = OgnlOps.class$("[Ljava.math.BigDecimal;", false);
        }
        if (c == clazz10) {
            return 9;
        }
        return 10;
    }

    public static Object convertValue(Object value, Class toType) {
        Object result = null;
        if (value != null) {
            Class clazz;
            Class clazz2;
            Class clazz3;
            Class clazz4;
            Class clazz5;
            Class clazz6;
            Class clazz7;
            Class clazz8;
            Class clazz9;
            Class clazz10;
            Class clazz11 = class$java$lang$Integer;
            if (clazz11 == null) {
                clazz11 = class$java$lang$Integer = OgnlOps.class$("[Ljava.lang.Integer;", false);
            }
            if (toType == clazz11 || toType == Integer.TYPE) {
                result = new Integer((int)OgnlOps.longValue(value));
            }
            if ((clazz10 = class$java$lang$Double) == null) {
                clazz10 = class$java$lang$Double = OgnlOps.class$("[Ljava.lang.Double;", false);
            }
            if (toType == clazz10 || toType == Double.TYPE) {
                result = new Double(OgnlOps.doubleValue(value));
            }
            if ((clazz9 = class$java$lang$Boolean) == null) {
                clazz9 = class$java$lang$Boolean = OgnlOps.class$("[Ljava.lang.Boolean;", false);
            }
            if (toType == clazz9 || toType == Boolean.TYPE) {
                result = OgnlOps.booleanValue(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            if ((clazz8 = class$java$lang$Byte) == null) {
                clazz8 = class$java$lang$Byte = OgnlOps.class$("[Ljava.lang.Byte;", false);
            }
            if (toType == clazz8 || toType == Byte.TYPE) {
                result = new Byte((byte)OgnlOps.longValue(value));
            }
            if ((clazz7 = class$java$lang$Character) == null) {
                clazz7 = class$java$lang$Character = OgnlOps.class$("[Ljava.lang.Character;", false);
            }
            if (toType == clazz7 || toType == Character.TYPE) {
                result = new Character((char)OgnlOps.longValue(value));
            }
            if ((clazz6 = class$java$lang$Short) == null) {
                clazz6 = class$java$lang$Short = OgnlOps.class$("[Ljava.lang.Short;", false);
            }
            if (toType == clazz6 || toType == Short.TYPE) {
                result = new Short((short)OgnlOps.longValue(value));
            }
            if ((clazz5 = class$java$lang$Long) == null) {
                clazz5 = class$java$lang$Long = OgnlOps.class$("[Ljava.lang.Long;", false);
            }
            if (toType == clazz5 || toType == Long.TYPE) {
                result = new Long(OgnlOps.longValue(value));
            }
            if ((clazz4 = class$java$lang$Float) == null) {
                clazz4 = class$java$lang$Float = OgnlOps.class$("[Ljava.lang.Float;", false);
            }
            if (toType == clazz4 || toType == Float.TYPE) {
                result = new Float(OgnlOps.doubleValue(value));
            }
            if ((clazz3 = class$java$math$BigInteger) == null) {
                clazz3 = class$java$math$BigInteger = OgnlOps.class$("[Ljava.math.BigInteger;", false);
            }
            if (toType == clazz3) {
                result = OgnlOps.bigIntValue(value);
            }
            if ((clazz2 = class$java$math$BigDecimal) == null) {
                clazz2 = class$java$math$BigDecimal = OgnlOps.class$("[Ljava.math.BigDecimal;", false);
            }
            if (toType == clazz2) {
                result = OgnlOps.bigDecValue(value);
            }
            if ((clazz = class$java$lang$String) == null) {
                clazz = class$java$lang$String = OgnlOps.class$("[Ljava.lang.String;", false);
            }
            if (toType == clazz) {
                result = value.toString();
            }
        }
        return result;
    }

    public static int getNumericType(Object v1, Object v2) {
        return OgnlOps.getNumericType(v1, v2, false);
    }

    public static int getNumericType(Object v1, Object v2, boolean canBeNonNumeric) {
        int t2;
        int t1 = OgnlOps.getNumericType(v1);
        if (t1 == (t2 = OgnlOps.getNumericType(v2))) {
            return t1;
        }
        if (canBeNonNumeric && (t1 == 10 || t2 == 10 || t1 == 2 || t2 == 2)) {
            return 10;
        }
        if (t1 == 10) {
            t1 = 8;
        }
        if (t2 == 10) {
            t2 = 8;
        }
        if (t1 >= 7) {
            if (t2 >= 7) {
                return Math.max(t1, t2);
            }
            if (t2 < 4) {
                return t1;
            }
            if (t2 == 6) {
                return 9;
            }
            return Math.max(8, t1);
        }
        if (t2 >= 7) {
            if (t1 < 4) {
                return t2;
            }
            if (t1 == 6) {
                return 9;
            }
            return Math.max(8, t2);
        }
        return Math.max(t1, t2);
    }

    public static Number newInteger(int type, long value) {
        switch (type) {
            case 0: 
            case 2: 
            case 4: {
                return new Integer((int)value);
            }
            case 7: {
                if ((long)((float)value) == value) {
                    return new Float(value);
                }
            }
            case 8: {
                if ((long)((double)value) == value) {
                    return new Double(value);
                }
            }
            case 5: {
                return new Long(value);
            }
            case 1: {
                return new Byte((byte)value);
            }
            case 3: {
                return new Short((short)value);
            }
        }
        return BigInteger.valueOf(value);
    }

    public static Number newReal(int type, double value) {
        if (type == 7) {
            return new Float((float)value);
        }
        return new Double(value);
    }

    public static Object binaryOr(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).or(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) | OgnlOps.longValue(v2));
    }

    public static Object binaryXor(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).xor(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) ^ OgnlOps.longValue(v2));
    }

    public static Object binaryAnd(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).and(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) & OgnlOps.longValue(v2));
    }

    public static boolean equal(Object v1, Object v2) {
        if (v1 == null) {
            boolean bl = false;
            if (v2 == null) {
                bl = true;
            }
            return bl;
        }
        if (v1 == v2 || v1.equals(v2)) {
            return true;
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            boolean bl = false;
            if (((Number)v1).doubleValue() == ((Number)v2).doubleValue()) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static boolean less(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2, true);
        switch (type) {
            case 6: {
                boolean bl = false;
                if (OgnlOps.bigIntValue(v1).compareTo(OgnlOps.bigIntValue(v2)) < 0) {
                    bl = true;
                }
                return bl;
            }
            case 9: {
                boolean bl = false;
                if (OgnlOps.bigDecValue(v1).compareTo(OgnlOps.bigDecValue(v2)) < 0) {
                    bl = true;
                }
                return bl;
            }
            case 10: {
                if (v1 instanceof Comparable) {
                    boolean bl = false;
                    if (((Comparable)v1).compareTo(v2) < 0) {
                        bl = true;
                    }
                    return bl;
                }
            }
            case 7: 
            case 8: {
                boolean bl = false;
                if (OgnlOps.doubleValue(v1) < OgnlOps.doubleValue(v2)) {
                    bl = true;
                }
                return bl;
            }
        }
        boolean bl = false;
        if (OgnlOps.longValue(v1) < OgnlOps.longValue(v2)) {
            bl = true;
        }
        return bl;
    }

    public static boolean greater(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2, true);
        switch (type) {
            case 6: {
                boolean bl = false;
                if (OgnlOps.bigIntValue(v1).compareTo(OgnlOps.bigIntValue(v2)) > 0) {
                    bl = true;
                }
                return bl;
            }
            case 9: {
                boolean bl = false;
                if (OgnlOps.bigDecValue(v1).compareTo(OgnlOps.bigDecValue(v2)) > 0) {
                    bl = true;
                }
                return bl;
            }
            case 10: {
                if (v1 instanceof Comparable) {
                    boolean bl = false;
                    if (((Comparable)v1).compareTo(v2) < 0) {
                        bl = true;
                    }
                    return bl;
                }
            }
            case 7: 
            case 8: {
                boolean bl = false;
                if (OgnlOps.doubleValue(v1) > OgnlOps.doubleValue(v2)) {
                    bl = true;
                }
                return bl;
            }
        }
        boolean bl = false;
        if (OgnlOps.longValue(v1) > OgnlOps.longValue(v2)) {
            bl = true;
        }
        return bl;
    }

    public static boolean in(Object v1, Object v2) throws OgnlException {
        if (v2 == null) {
            return false;
        }
        ElementsAccessor e = OgnlRuntime.getElementsAccessor(v2.getClass());
        Enumeration enumeration = e.getElements(v2);
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!OgnlOps.equal(v1, o)) continue;
            return true;
        }
        return false;
    }

    public static Object shiftLeft(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).shiftLeft((int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) << (int)OgnlOps.longValue(v2));
    }

    public static Object shiftRight(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).shiftRight((int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) >> (int)OgnlOps.longValue(v2));
    }

    public static Object unsignedShiftRight(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).shiftRight((int)OgnlOps.longValue(v2));
        }
        if (type <= 4) {
            return OgnlOps.newInteger(4, (int)OgnlOps.longValue(v1) >>> (int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) >>> (int)OgnlOps.longValue(v2));
    }

    public static Object add(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2, true);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).add(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).add(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) + OgnlOps.doubleValue(v2));
            }
            case 10: {
                return v1.toString() + v2.toString();
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) + OgnlOps.longValue(v2));
    }

    public static Object subtract(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).subtract(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).subtract(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) - OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) - OgnlOps.longValue(v2));
    }

    public static Object multiply(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).multiply(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).multiply(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) * OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) * OgnlOps.longValue(v2));
    }

    public static Object divide(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).divide(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).divide(OgnlOps.bigDecValue(v2), 6);
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) / OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) / OgnlOps.longValue(v2));
    }

    public static Object remainder(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(v1).remainder(OgnlOps.bigIntValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) % OgnlOps.longValue(v2));
    }

    public static Object negate(Object value) {
        int type = OgnlOps.getNumericType(value);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(value).negate();
            }
            case 9: {
                return OgnlOps.bigDecValue(value).negate();
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, -OgnlOps.doubleValue(value));
            }
        }
        return OgnlOps.newInteger(type, -OgnlOps.longValue(value));
    }

    public static Object bitNegate(Object value) {
        int type = OgnlOps.getNumericType(value);
        switch (type) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(value).not();
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(value) ^ -1L);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

