/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ognl.ClassResolver;
import ognl.DefaultClassResolver;
import ognl.DefaultMemberAccess;
import ognl.DefaultTypeConverter;
import ognl.Evaluation;
import ognl.MemberAccess;
import ognl.TypeConverter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OgnlContext
implements Map {
    public static final String CONTEXT_CONTEXT_KEY = "context";
    public static final String ROOT_CONTEXT_KEY = "root";
    public static final String THIS_CONTEXT_KEY = "this";
    public static final String LAST_EVALUATION_CONTEXT_KEY = "_lastEvaluation";
    public static final String CLASS_RESOLVER_CONTEXT_KEY = "_classResolver";
    public static final String TYPE_CONVERTER_CONTEXT_KEY = "_typeConverter";
    public static final String MEMBER_ACCESS_CONTEXT_KEY = "_memberAccess";
    public static final ClassResolver DEFAULT_CLASS_RESOLVER = new DefaultClassResolver();
    public static final TypeConverter DEFAULT_TYPE_CONVERTER = new DefaultTypeConverter();
    public static final MemberAccess DEFAULT_MEMBER_ACCESS = new DefaultMemberAccess(false);
    private static Map RESERVED_KEYS = new HashMap(11);
    private Object root;
    private Object currentObject;
    private Evaluation rootEvaluation;
    private Evaluation currentEvaluation;
    private Evaluation lastEvaluation;
    private Map values;
    private ClassResolver classResolver;
    private TypeConverter typeConverter;
    private MemberAccess memberAccess;

    public void setValues(Map value) {
        Iterator it = value.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            this.values.put(k, value.get(k));
        }
    }

    public void setClassResolver(ClassResolver value) {
        if (value == null) {
            throw new IllegalArgumentException("cannot set ClassResolver to null");
        }
        this.classResolver = value;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public void setTypeConverter(TypeConverter value) {
        if (value == null) {
            throw new IllegalArgumentException("cannot set TypeConverter to null");
        }
        this.typeConverter = value;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public void setMemberAccess(MemberAccess value) {
        if (value == null) {
            throw new IllegalArgumentException("cannot set MemberAccess to null");
        }
        this.memberAccess = value;
    }

    public MemberAccess getMemberAccess() {
        return this.memberAccess;
    }

    public void setRoot(Object value) {
        this.root = value;
    }

    public Object getRoot() {
        return this.root;
    }

    public Evaluation getLastEvaluation() {
        return this.lastEvaluation;
    }

    public void setLastEvaluation(Evaluation value) {
        this.lastEvaluation = value;
    }

    public void setCurrentObject(Object value) {
        this.currentObject = value;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public Evaluation getCurrentEvaluation() {
        return this.currentEvaluation;
    }

    public void setCurrentEvaluation(Evaluation value) {
        this.currentEvaluation = value;
    }

    public Evaluation getRootEvaluation() {
        return this.rootEvaluation;
    }

    public void setRootEvaluation(Evaluation value) {
        this.rootEvaluation = value;
    }

    public Evaluation getEvaluation(int relativeIndex) {
        Evaluation result = null;
        if (relativeIndex <= 0) {
            result = this.currentEvaluation;
            while (++relativeIndex < 0 && result != null) {
                result = result.getParent();
            }
        }
        return result;
    }

    public void pushEvaluation(Evaluation value) {
        if (this.currentEvaluation != null) {
            this.currentEvaluation.addChild(value);
        } else {
            this.setRootEvaluation(value);
        }
        this.setCurrentEvaluation(value);
    }

    public Evaluation popEvaluation() {
        Evaluation result = this.currentEvaluation;
        this.setCurrentEvaluation(result.getParent());
        if (this.currentEvaluation == null) {
            this.setLastEvaluation(result);
            this.setRootEvaluation(null);
        }
        return result;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(Object key) {
        void var2_11;
        if (RESERVED_KEYS.containsKey(key)) {
            if (key.equals(THIS_CONTEXT_KEY)) {
                Object object = this.getCurrentObject();
                return var2_11;
            } else if (key.equals(ROOT_CONTEXT_KEY)) {
                Object object = this.getRoot();
                return var2_11;
            } else if (key.equals(CONTEXT_CONTEXT_KEY)) {
                OgnlContext ognlContext = this;
                return var2_11;
            } else if (key.equals(LAST_EVALUATION_CONTEXT_KEY)) {
                Evaluation evaluation = this.getLastEvaluation();
                return var2_11;
            } else if (key.equals(CLASS_RESOLVER_CONTEXT_KEY)) {
                ClassResolver classResolver = this.getClassResolver();
                return var2_11;
            } else if (key.equals(TYPE_CONVERTER_CONTEXT_KEY)) {
                TypeConverter typeConverter = this.getTypeConverter();
                return var2_11;
            } else {
                if (!key.equals(MEMBER_ACCESS_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key + '\'');
                MemberAccess memberAccess = this.getMemberAccess();
            }
            return var2_11;
        } else {
            Object v = this.values.get(key);
        }
        return var2_11;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value) {
        Object result;
        if (!RESERVED_KEYS.containsKey(key)) return this.values.put(key, value);
        if (key.equals(THIS_CONTEXT_KEY)) {
            result = this.getCurrentObject();
            this.setCurrentObject(value);
            return result;
        } else if (key.equals(ROOT_CONTEXT_KEY)) {
            result = this.getRoot();
            this.setRoot(value);
            return result;
        } else {
            if (key.equals(CONTEXT_CONTEXT_KEY)) {
                throw new IllegalArgumentException("can't change context in context");
            }
            if (key.equals(LAST_EVALUATION_CONTEXT_KEY)) {
                result = this.getLastEvaluation();
                this.lastEvaluation = (Evaluation)value;
                return result;
            } else if (key.equals(CLASS_RESOLVER_CONTEXT_KEY)) {
                result = this.getClassResolver();
                this.setClassResolver((ClassResolver)value);
                return result;
            } else if (key.equals(TYPE_CONVERTER_CONTEXT_KEY)) {
                result = this.getTypeConverter();
                this.setTypeConverter((TypeConverter)value);
                return result;
            } else {
                if (!key.equals(MEMBER_ACCESS_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key + '\'');
                result = this.getMemberAccess();
                this.setMemberAccess((MemberAccess)value);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object remove(Object key) {
        void var2_10;
        if (RESERVED_KEYS.containsKey(key)) {
            if (key.equals(THIS_CONTEXT_KEY)) {
                Object object = this.getCurrentObject();
                this.setCurrentObject(null);
                return var2_10;
            } else if (key.equals(ROOT_CONTEXT_KEY)) {
                Object object = this.getRoot();
                this.setRoot(null);
                return var2_10;
            } else {
                if (key.equals(CONTEXT_CONTEXT_KEY)) {
                    throw new IllegalArgumentException("can't remove context from context");
                }
                if (key.equals(LAST_EVALUATION_CONTEXT_KEY)) {
                    Evaluation evaluation = this.lastEvaluation;
                    this.setLastEvaluation(null);
                    return var2_10;
                } else if (key.equals(CLASS_RESOLVER_CONTEXT_KEY)) {
                    ClassResolver classResolver = this.getClassResolver();
                    this.setClassResolver(null);
                    return var2_10;
                } else if (key.equals(TYPE_CONVERTER_CONTEXT_KEY)) {
                    TypeConverter typeConverter = this.getTypeConverter();
                    this.setTypeConverter(null);
                    return var2_10;
                } else {
                    if (!key.equals(MEMBER_ACCESS_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key + '\'');
                    MemberAccess memberAccess = this.getMemberAccess();
                    this.setMemberAccess(null);
                }
            }
            return var2_10;
        } else {
            Object v = this.values.remove(key);
        }
        return var2_10;
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            this.put(k, t.get(k));
        }
    }

    public void clear() {
        this.values.clear();
        this.setRoot(null);
        this.setCurrentObject(null);
        this.setRootEvaluation(null);
        this.setCurrentEvaluation(null);
        this.setLastEvaluation(null);
        this.setClassResolver(DEFAULT_CLASS_RESOLVER);
        this.setTypeConverter(DEFAULT_TYPE_CONVERTER);
        this.setMemberAccess(DEFAULT_MEMBER_ACCESS);
    }

    public Set keySet() {
        return this.values.keySet();
    }

    public Collection values() {
        return this.values.values();
    }

    public Set entrySet() {
        return this.values.entrySet();
    }

    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    private final /* synthetic */ void this() {
        this.values = new HashMap(23);
        this.classResolver = DEFAULT_CLASS_RESOLVER;
        this.typeConverter = DEFAULT_TYPE_CONVERTER;
        this.memberAccess = DEFAULT_MEMBER_ACCESS;
    }

    public OgnlContext() {
        this.this();
    }

    public OgnlContext(ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess) {
        this();
        if (classResolver != null) {
            this.classResolver = classResolver;
        }
        if (typeConverter != null) {
            this.typeConverter = typeConverter;
        }
        if (memberAccess != null) {
            this.memberAccess = memberAccess;
        }
    }

    public OgnlContext(Map values) {
        this.this();
        this.values = values;
    }

    public OgnlContext(ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess, Map values) {
        this(classResolver, typeConverter, memberAccess);
        this.values = values;
    }

    static {
        RESERVED_KEYS.put(CONTEXT_CONTEXT_KEY, null);
        RESERVED_KEYS.put(ROOT_CONTEXT_KEY, null);
        RESERVED_KEYS.put(THIS_CONTEXT_KEY, null);
        RESERVED_KEYS.put(LAST_EVALUATION_CONTEXT_KEY, null);
        RESERVED_KEYS.put(CLASS_RESOLVER_CONTEXT_KEY, null);
        RESERVED_KEYS.put(TYPE_CONVERTER_CONTEXT_KEY, null);
        RESERVED_KEYS.put(MEMBER_ACCESS_CONTEXT_KEY, null);
    }
}

