/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import java.util.Map;
import ognl.ASTProperty;
import ognl.DynamicSubscript;
import ognl.Evaluation;
import ognl.NoSuchPropertyException;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;

public class ArrayPropertyAccessor
extends ObjectPropertyAccessor
implements PropertyAccessor {
    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        Object result = null;
        if (name instanceof String) {
            result = name.equals("length") ? new Integer(Array.getLength(target)) : super.getProperty(context, target, name);
        } else {
            int index = -1;
            if (name instanceof Number) {
                index = ((Number)name).intValue();
            } else if (name instanceof DynamicSubscript) {
                int len = Array.getLength(target);
                switch (((DynamicSubscript)name).getFlag()) {
                    case 3: {
                        result = Array.newInstance(target.getClass().getComponentType(), len);
                        System.arraycopy(target, 0, result, 0, len);
                    }
                    case 0: {
                        int n = 0;
                        if (len > 0) {
                            n = 1;
                        }
                        index = n + -1;
                        break;
                    }
                    case 1: {
                        index = len > 0 ? len / 2 : -1;
                        break;
                    }
                    case 2: {
                        index = len > 0 ? len - 1 : -1;
                        break;
                    }
                }
            } else {
                throw new NoSuchPropertyException(target, name);
            }
            if (result == null) {
                Object lastSource;
                ASTProperty lastPropertyNode;
                boolean useIndex = true;
                OgnlContext ognlContext = (OgnlContext)context;
                Evaluation previousEval = ognlContext.getCurrentEvaluation().getPrevious();
                if (previousEval != null && previousEval.getNode() instanceof ASTProperty && (lastPropertyNode = (ASTProperty)previousEval.getNode()).isIndexedProperty(ognlContext, lastSource = previousEval.getSource())) {
                    result = OgnlRuntime.getIndexedProperty(ognlContext, lastSource, (String)lastPropertyNode.getProperty(ognlContext, lastSource), index);
                    useIndex = false;
                }
                if (useIndex) {
                    result = index >= 0 ? Array.get(target, index) : null;
                }
            }
        }
        return result;
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        if (name instanceof String) {
            super.setProperty(context, target, name, value);
            return;
        }
        int index = -1;
        if (name instanceof Number) {
            index = ((Number)name).intValue();
        } else if (name instanceof DynamicSubscript) {
            int len = Array.getLength(target);
            switch (((DynamicSubscript)name).getFlag()) {
                case 3: {
                    System.arraycopy(target, 0, value, 0, len);
                    return;
                }
                case 0: {
                    int n = 0;
                    if (len > 0) {
                        n = 1;
                    }
                    index = n + -1;
                    break;
                }
                case 1: {
                    index = len > 0 ? len / 2 : -1;
                    break;
                }
                case 2: {
                    index = len > 0 ? len - 1 : -1;
                    break;
                }
            }
        } else {
            throw new NoSuchPropertyException(target, name);
        }
        if (index >= 0) {
            Object lastSource;
            ASTProperty lastPropertyNode;
            boolean useIndex = true;
            OgnlContext ognlContext = (OgnlContext)context;
            Evaluation previousEval = ognlContext.getCurrentEvaluation().getPrevious();
            if (previousEval != null && previousEval.getNode() instanceof ASTProperty && (lastPropertyNode = (ASTProperty)previousEval.getNode()).isIndexedProperty(ognlContext, lastSource = previousEval.getSource())) {
                OgnlRuntime.setIndexedProperty(ognlContext, lastSource, (String)lastPropertyNode.getProperty(ognlContext, lastSource), index, value);
                useIndex = false;
            }
            if (useIndex) {
                Array.set(target, index, value);
            }
        }
    }
}

