/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import ognl.ASTConst;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.TypeConverter;

class ASTCtor
extends SimpleNode {
    private String className;
    private boolean isArray;

    void setClassName(String className) {
        this.className = className;
    }

    void setArray(boolean value) {
        this.isArray = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Object root = context.getRoot();
        int count = this.jjtGetNumChildren();
        ArrayList<Object> args = new ArrayList<Object>(count);
        int i = 0;
        while (i < count) {
            args.add(this.children[i].getValue(context, root));
            ++i;
        }
        if (!this.isArray) return OgnlRuntime.callConstructor(context, this.className, args);
        if (args.size() != 1) throw new OgnlException("only expect array size or fixed initializer list");
        try {
            int size;
            Class componentClass = OgnlRuntime.classForName(context, this.className);
            List sourceList = null;
            if (args.get(0) instanceof List) {
                sourceList = (List)args.get(0);
                size = sourceList.size();
            } else {
                size = (int)OgnlOps.longValue(args.get(0));
            }
            Object result = Array.newInstance(componentClass, size);
            if (sourceList == null) return result;
            TypeConverter converter = context.getTypeConverter();
            int i2 = 0;
            int icount = sourceList.size();
            while (i2 < icount) {
                Object o = sourceList.get(i2);
                if (o == null || componentClass.isInstance(o)) {
                    Array.set(result, i2, o);
                } else {
                    Array.set(result, i2, converter.convertValue(context, null, null, null, o, componentClass));
                }
                ++i2;
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new OgnlException("array component class '" + this.className + "' not found", ex);
        }
    }

    public String toString() {
        String result = "new " + this.className;
        if (this.isArray) {
            result = this.children[0] instanceof ASTConst ? result + '[' + this.children[0] + ']' : result + "[] " + this.children[0];
        } else {
            result = result + '(';
            if (this.children != null && this.children.length > 0) {
                int i = 0;
                while (i < this.children.length) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.children[i];
                    ++i;
                }
            }
            result = result + ')';
        }
        return result;
    }

    public ASTCtor(int id) {
        super(id);
    }

    public ASTCtor(OgnlParser p, int id) {
        super(p, id);
    }
}

