/*
 * Decompiled with CFR 0.152.
 */
package lime.upload;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import lime.upload.Upload;
import lime.upload.UploadLimitExceededException;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import ua.com.softway.tracker.util.Strings;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final FileUpload fileUpload;

    public MultipartRequestWrapper(HttpServletRequest request, FileUpload fileUpload) throws UploadLimitExceededException {
        super(request);
        this.fileUpload = fileUpload;
        this.parseMultipart(request);
    }

    public Map getParameterMap() {
        return this.params;
    }

    public Enumeration getParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public String getParameter(String name) {
        Object value = this.params.get(name);
        if (value == null || !(value instanceof String[])) {
            return null;
        }
        String[] values = (String[])value;
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        Object value = this.params.get(name);
        if (value == null || !(value instanceof String[])) {
            return null;
        }
        return (String[])value;
    }

    private void parseMultipart(HttpServletRequest request) throws UploadLimitExceededException {
        List fileItems;
        try {
            fileItems = this.fileUpload.parseRequest(request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw new UploadLimitExceededException(e);
        }
        catch (FileUploadException e) {
            throw new RuntimeException(e);
        }
        String encoding = request.getCharacterEncoding();
        for (FileItem fileItem : fileItems) {
            String name = fileItem.getFieldName();
            if (fileItem.isFormField()) {
                try {
                    String value = fileItem.getString(encoding);
                    this.addParam(name, value);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (Strings.isBlank(fileItem.getName())) continue;
            this.addParam(name, fileItem);
        }
    }

    private void addParam(String name, String value) {
        String[] newArray;
        if (this.params.containsKey(name)) {
            String[] oldArray = (String[])this.params.get(name);
            newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new String[]{value};
        }
        this.params.put(name, newArray);
    }

    private void addParam(String name, FileItem fileItem) {
        Upload[] newArray;
        Upload value = new Upload(fileItem);
        if (this.params.containsKey(name)) {
            Upload[] oldArray = (Upload[])this.params.get(name);
            newArray = new Upload[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new Upload[]{value};
        }
        this.params.put(name, newArray);
    }

    public static HttpServletRequest wrapIfNeeded(HttpServletRequest request, long limit) throws UploadLimitExceededException {
        if (FileUpload.isMultipartContent(request)) {
            FileUpload fileUpload = new FileUpload(new DefaultFileItemFactory());
            fileUpload.setSizeMax(limit);
            return new MultipartRequestWrapper(request, fileUpload);
        }
        return request;
    }
}

