/*
 * Decompiled with CFR 0.152.
 */
package lime.outcome;

import java.util.LinkedHashMap;
import java.util.Map;
import lime.Lime;
import lime.NamespacePath;

public class Redirect {
    public Class actionClass;
    public String methodName;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    public Redirect(Class actionClass, String methodName) {
        this.actionClass = actionClass;
        this.methodName = methodName;
    }

    public Redirect(Class actionClass, String methodName, String ... nameValuePairs) {
        this.actionClass = actionClass;
        this.methodName = methodName;
        if (nameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("nameValuePairs.length should be even");
        }
        for (int i = 0; i < nameValuePairs.length / 2; ++i) {
            this.setParameter(nameValuePairs[2 * i], nameValuePairs[2 * i + 1]);
        }
    }

    public Redirect(Class actionClass, String methodName, String[] parameters, String[] values) {
        if (parameters.length != values.length) {
            throw new IllegalArgumentException("parameters.length != values.length");
        }
        this.actionClass = actionClass;
        this.methodName = methodName;
        for (int i = 0; i < parameters.length; ++i) {
            this.setParameter(parameters[i], values[i]);
        }
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getPath() {
        String prefix = Lime.instance().getContextPath();
        NamespacePath namespacePath = this.actionClass.getAnnotation(NamespacePath.class);
        prefix = namespacePath != null ? prefix + namespacePath.value() + "/" : prefix + "/";
        String queryString = "";
        if (this.parameters.size() > 0) {
            queryString = queryString + "?";
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            queryString = queryString + entry.getKey() + "=" + entry.getValue() + "&";
        }
        if (queryString.endsWith("&")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        return prefix + this.actionClass.getSimpleName() + "." + this.methodName + queryString;
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Redirect) {
            Redirect that = (Redirect)obj;
            return that.getPath().equals(this.getPath());
        }
        return false;
    }
}

