/*
 * Decompiled with CFR 0.152.
 */
package lime.executor;

import java.util.ArrayList;
import java.util.List;
import lime.ActionPath;
import lime.NamespacePath;
import lime.executor.ActionNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFactory {
    private List<Object> actions = new ArrayList<Object>();

    public void addAction(Object action) {
        this.actions.add(action);
    }

    public List<Object> getActions() {
        return new ArrayList<Object>(this.actions);
    }

    public Object getAction(ActionPath path) throws ActionNotFoundException {
        Object action = this.findAction(path);
        if (action == null) {
            throw new ActionNotFoundException(path.getClassName());
        }
        return action;
    }

    private Object findAction(ActionPath path) {
        for (Object action : this.actions) {
            if (!action.getClass().getSimpleName().equals(path.getClassName())) continue;
            NamespacePath namespacePath = action.getClass().getAnnotation(NamespacePath.class);
            if (namespacePath == null) {
                return action;
            }
            if (!path.getNamespacePath().equals(namespacePath.value())) continue;
            return action;
        }
        return null;
    }
}

