/*
 * Decompiled with CFR 0.152.
 */
package lime;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lime.ActionPath;
import lime.Filter;
import lime.FilterChain;
import lime.InvalidActionPathException;
import lime.Lime;
import lime.NamespacePath;
import lime.executor.ActionFactory;
import lime.executor.ActionNotFoundException;
import lime.executor.Collector;
import lime.executor.OutcomeHandler;
import lime.executor.Populator;
import lime.executor.UploadLimit;
import lime.handler.ChainedOutcomeHandler;
import lime.upload.MultipartRequestWrapper;
import lime.upload.UploadLimitExceededException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Namespace {
    private String path;
    private Populator populator = new Populator();
    private Collector collector = new Collector();
    private ActionFactory actionFactory = new ActionFactory();
    private ChainedOutcomeHandler chainedOutcomeHandler = new ChainedOutcomeHandler();
    private List<Filter> filters = new ArrayList<Filter>();

    public Namespace(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("namespace path should start with a slash");
        }
        this.path = path;
    }

    public String getPath() {
        return Lime.instance().getContextPath() + this.path;
    }

    public void addAction(Object action) {
        NamespacePath namespacePath = action.getClass().getAnnotation(NamespacePath.class);
        if (namespacePath == null) {
            throw new IllegalArgumentException("action " + action.getClass().getName() + " is not withing any namespace");
        }
        if (!namespacePath.value().equals(this.path)) {
            throw new IllegalArgumentException("action " + action.getClass().getName() + " is withing namespace " + namespacePath.value() + " instead of " + this.path);
        }
        this.actionFactory.addAction(action);
    }

    public List<Object> getActions() {
        return this.actionFactory.getActions();
    }

    public void addOutcomeHandler(OutcomeHandler outcomeHandler) {
        this.chainedOutcomeHandler.addHandler(outcomeHandler);
    }

    public List<OutcomeHandler> getOutcomeHandlers() {
        return this.chainedOutcomeHandler.getHandlers();
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public List<Filter> getFilters() {
        return new ArrayList<Filter>(this.filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Method method;
            ActionPath path = new ActionPath(request.getServletPath());
            Object action = this.actionFactory.getAction(path);
            if (!FilterChain.execute(this.filters, action, request, response)) {
                return;
            }
            UploadLimit uploadLimit = action.getClass().getAnnotation(UploadLimit.class);
            long limit = uploadLimit != null ? uploadLimit.limit() : -1L;
            try {
                request = MultipartRequestWrapper.wrapIfNeeded(request, limit);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                this.collector.collect(request, properties);
                this.populator.populate(action, properties);
                method = action.getClass().getMethod(path.getMethodName(), new Class[0]);
            }
            catch (UploadLimitExceededException e) {
                if (uploadLimit == null) {
                    throw new ServletException(e);
                }
                method = action.getClass().getMethod(uploadLimit.limitExceededMethod(), new Class[0]);
            }
            Class<Namespace> clazz = Namespace.class;
            synchronized (Namespace.class) {
                Object outcome = method.invoke(action, new Object[0]);
                // ** MonitorExit[var10_15] (shouldn't be in output)
                if (!this.chainedOutcomeHandler.handle(action, outcome, request, response)) {
                    throw new ServletException("No handler for " + outcome);
                }
            }
        }
        catch (ActionNotFoundException e) {
            response.sendError(404);
        }
        catch (InvalidActionPathException e) {
            response.sendError(404);
        }
        catch (NoSuchMethodException e) {
            response.sendError(404);
        }
        catch (IllegalAccessException e) {
            throw new ServletException(e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException(e.getTargetException());
        }
    }
}

