/*
 * Decompiled with CFR 0.152.
 */
package lime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lime.ActionPath;
import lime.InvalidActionPathException;
import lime.Namespace;
import lime.NamespaceTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lime {
    private NamespaceTemplate namespaceTemplate = new NamespaceTemplate();
    private List<Namespace> namespaces = new ArrayList<Namespace>();
    private final String contextPath;
    private static ThreadLocal<Lime> instance = new ThreadLocal();

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Namespace namespace = this.findApropriateNamespace(request.getContextPath() + request.getServletPath());
        if (namespace == null) {
            response.sendError(404);
        } else {
            namespace.process(request, response);
        }
    }

    private Namespace findApropriateNamespace(String servletPath) {
        try {
            ActionPath actionPath = new ActionPath(servletPath);
            return this.getNamespace(actionPath.getNamespacePath());
        }
        catch (InvalidActionPathException e) {
            return null;
        }
    }

    public Namespace addNamespace(String namespacePath) {
        if (!namespacePath.startsWith("/")) {
            throw new IllegalArgumentException("namespace path shoud start with slash");
        }
        if (this.getNamespace(namespacePath) != null) {
            throw new IllegalArgumentException("namespace with path " + namespacePath + "already exists");
        }
        Namespace namespace = new Namespace(namespacePath);
        this.namespaceTemplate.applyTo(namespace);
        this.namespaces.add(namespace);
        return namespace;
    }

    public List<Namespace> getNamespaces() {
        return new ArrayList<Namespace>(this.namespaces);
    }

    public Namespace getNamespace(String namespacePath) {
        for (Namespace namespace : this.namespaces) {
            if (!namespace.getPath().equals(namespacePath)) continue;
            return namespace;
        }
        return null;
    }

    public NamespaceTemplate getNamespaceTemplate() {
        return this.namespaceTemplate;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public static Lime init(String contextPath) {
        Lime lime = new Lime(contextPath);
        instance.set(lime);
        return lime;
    }

    public static Lime instance() {
        if (instance.get() == null) {
            throw new IllegalStateException("Lime not initialized. Call init");
        }
        return instance.get();
    }

    Lime() {
        this("/");
    }

    Lime(String contextPath) {
        if (contextPath.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        this.contextPath = contextPath;
    }
}

