/*
 * Decompiled with CFR 0.152.
 */
package lime;

import java.lang.reflect.Method;
import lime.InvalidActionUrlException;

public class ActionUrl {
    private Class actionClass;
    private Method actionMethod;

    public ActionUrl(Class actionClass, Method actionMethod) {
        this.actionClass = actionClass;
        this.actionMethod = actionMethod;
    }

    public Class getActionClass() {
        return this.actionClass;
    }

    public Method getActionMethod() {
        return this.actionMethod;
    }

    public static ActionUrl valueOf(String url) throws InvalidActionUrlException {
        int dotIndex = url.indexOf(46);
        if (dotIndex == -1) {
            throw new InvalidActionUrlException(url, "single dot expected");
        }
        String[] parts = url.split("\\.");
        if (parts.length != 2) {
            throw new InvalidActionUrlException(url, "single dot expected");
        }
        String className = parts[0];
        String methodName = parts[1];
        int firstSlashIndex = methodName.indexOf("/");
        if (firstSlashIndex != -1) {
            methodName = methodName.substring(0, firstSlashIndex);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod(methodName, new Class[0]);
            return new ActionUrl(clazz, method);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidActionUrlException(url, e);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidActionUrlException(url, e);
        }
    }
}

