/*
 * Decompiled with CFR 0.152.
 */
package lime;

import lime.InvalidActionPathException;

public class ActionPath {
    private String methodName;
    private String className;
    private String namespacePath;

    public ActionPath(String actionPath) throws InvalidActionPathException {
        int dotIndex = actionPath.indexOf(46);
        if (dotIndex == -1) {
            throw new InvalidActionPathException(actionPath);
        }
        String[] parts = actionPath.split("\\.");
        if (parts.length < 2) {
            throw new InvalidActionPathException(actionPath);
        }
        this.className = parts[0];
        this.methodName = parts[1];
        int lastSlashIndex = this.className.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            this.namespacePath = this.className.substring(0, lastSlashIndex);
            this.className = this.className.substring(lastSlashIndex + 1);
        } else {
            this.namespacePath = "/";
        }
        int firstSlashIndex = this.methodName.indexOf("/");
        if (firstSlashIndex != -1) {
            this.methodName = this.methodName.substring(0, firstSlashIndex);
        }
        if ("".equals(this.className) || "".equals(this.methodName)) {
            throw new InvalidActionPathException(actionPath);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getNamespacePath() {
        return this.namespacePath;
    }
}

