/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.utils;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ServletUtils {
    public static final String request_attr_ORIGINAL_PATH = "javax.servlet.include.servlet_path";

    public static String getOriginalServletPath(HttpServletRequest httpServletRequest) {
        String servletPath = (String)httpServletRequest.getAttribute(request_attr_ORIGINAL_PATH);
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        return servletPath;
    }

    public static boolean isOriginal(ServletRequest servletRequest) {
        String servletPath = (String)servletRequest.getAttribute(request_attr_ORIGINAL_PATH);
        return servletPath == null;
    }

    public static void dispatch(ServletRequest request, ServletResponse response, String dispatchTo) throws RuntimeException {
        RequestDispatcher dispatcher = request.getRequestDispatcher(dispatchTo);
        if (dispatcher == null) {
            throw new RuntimeException("Can't find resource dispatcher for resource: " + dispatchTo);
        }
        ServletUtils.dispatch(request, response, dispatcher);
    }

    private static void dispatch(ServletRequest request, ServletResponse response, RequestDispatcher dispatcher) throws RuntimeException {
        try {
            if (ServletUtils.isOriginal(request)) {
                dispatcher.forward(request, response);
            } else {
                dispatcher.include(request, response);
            }
        }
        catch (ServletException se) {
            throw new RuntimeException("Can't dispatch", se);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Can't dispatch", ioe);
        }
    }
}

