/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.upload;

import com.priocom.web.upload.FileItem;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final FileUpload fileUpload;
    private final boolean isMultipart;

    public MultipartRequestWrapper(HttpServletRequest request, FileUpload fileUpload) {
        super(request);
        this.fileUpload = fileUpload;
        this.isMultipart = FileUpload.isMultipartContent(request) ? this.parseMultipart(request) : false;
    }

    public Map getParameterMap() {
        if (!this.isMultipart) {
            return super.getParameterMap();
        }
        return this.params;
    }

    public Enumeration getParameterNames() {
        if (!this.isMultipart) {
            return super.getParameterNames();
        }
        return new Vector(this.params.keySet()).elements();
    }

    public String getParameter(String name) {
        if (!this.isMultipart) {
            return super.getParameter(name);
        }
        Object value = this.params.get(name);
        if (value == null || !(value instanceof String[])) {
            return null;
        }
        String[] values = (String[])value;
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        if (!this.isMultipart) {
            return super.getParameterValues(name);
        }
        Object value = this.params.get(name);
        if (value == null || !(value instanceof String[])) {
            return null;
        }
        return (String[])value;
    }

    private boolean parseMultipart(HttpServletRequest request) {
        List fileItems;
        try {
            fileItems = this.fileUpload.parseRequest(request);
        }
        catch (FileUploadException e) {
            return false;
        }
        String characterEncoding = request.getCharacterEncoding();
        for (org.apache.commons.fileupload.FileItem fileItem : fileItems) {
            String name = fileItem.getFieldName();
            if (fileItem.isFormField()) {
                try {
                    String value = fileItem.getString(characterEncoding);
                    this.addParam(name, value);
                }
                catch (UnsupportedEncodingException e) {}
                continue;
            }
            if (fileItem.getSize() <= 0L) continue;
            this.addParam(name, fileItem);
        }
        return true;
    }

    private void addParam(String name, String value) {
        String[] newArray;
        if (this.params.containsKey(name)) {
            String[] oldArray = (String[])this.params.get(name);
            newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new String[]{value};
        }
        this.params.put(name, newArray);
    }

    private void addParam(String name, org.apache.commons.fileupload.FileItem va) {
        FileItem[] newArray;
        FileItem value = new FileItem(va);
        if (this.params.containsKey(name)) {
            FileItem[] oldArray = (FileItem[])this.params.get(name);
            newArray = new FileItem[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new FileItem[]{value};
        }
        this.params.put(name, newArray);
    }
}

