/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.pico;

import com.priocom.web.pico.ContainerHelper;
import com.priocom.web.pico.WebContainerComposer;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ServletContainerListener
implements ServletContextListener,
HttpSessionListener,
Serializable {
    public static final String CONTAINER_COMPOSER = "containerComposer";

    static WebContainerComposer getComposer(ServletContext context) {
        String param = context.getInitParameter(CONTAINER_COMPOSER);
        if (param == null && (param = context.getInitParameter("org.nanocontainer.integrationkit.ContainerComposer")) == null) {
            throw new RuntimeException("WebContainerComposer class should be specified in containerComposer parameter");
        }
        try {
            return (WebContainerComposer)Class.forName(param).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        WebContainerComposer composer = ServletContainerListener.getComposer(context);
        DefaultPicoContainer container = new DefaultPicoContainer();
        composer.initContextContainer(container, context);
        ContainerHelper.setApplicationContainer(context, container);
        container.start();
    }

    public void contextDestroyed(ServletContextEvent event) {
        MutablePicoContainer container = ContainerHelper.getApplicationContainer(event.getServletContext());
        container.stop();
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        MutablePicoContainer parent = ContainerHelper.getApplicationContainer(event.getSession().getServletContext());
        DefaultPicoContainer container = new DefaultPicoContainer(parent);
        ServletContainerListener.getComposer(session.getServletContext()).initSessionContainer(container, session);
        ContainerHelper.setSessionContainer(session, container);
        container.start();
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        MutablePicoContainer container = ContainerHelper.getSessionContainer(event.getSession());
        container.stop();
    }
}

