/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.pico;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class ContainerHelper {
    private static final String APPLICATION_CONTAINER = "nanocontainer.application";
    private static final String SESSION_CONTAINER = "nanocontainer.session";
    private static final String REQUEST_CONTAINER = "nanocontainer.request";

    public static PicoContainer getContainer(HttpServletRequest request) {
        MutablePicoContainer container = ContainerHelper.getRequestContainer(request);
        if (container == null) {
            container = ContainerHelper.getSessionContainer(request.getSession());
        }
        if (container == null) {
            container = ContainerHelper.getApplicationContainer(request.getSession().getServletContext());
        }
        if (container == null) {
            throw new RuntimeException("No Container found in request, session or application");
        }
        return container;
    }

    public static MutablePicoContainer getApplicationContainer(ServletContext ctx) {
        return (MutablePicoContainer)ctx.getAttribute(APPLICATION_CONTAINER);
    }

    static void setApplicationContainer(ServletContext ctx, MutablePicoContainer pico) {
        ctx.setAttribute(APPLICATION_CONTAINER, pico);
    }

    public static MutablePicoContainer getRequestContainer(HttpServletRequest request) {
        return (MutablePicoContainer)request.getAttribute(REQUEST_CONTAINER);
    }

    static void setRequestContainer(HttpServletRequest ctx, MutablePicoContainer pico) {
        ctx.setAttribute(REQUEST_CONTAINER, pico);
    }

    public static MutablePicoContainer getSessionContainer(HttpSession session) {
        return (MutablePicoContainer)session.getAttribute(SESSION_CONTAINER);
    }

    static void setSessionContainer(HttpSession ctx, MutablePicoContainer pico) {
        ctx.setAttribute(SESSION_CONTAINER, pico);
    }

    public static MutablePicoContainer getSessionContainer(HttpServletRequest request) {
        return ContainerHelper.getSessionContainer(request.getSession());
    }
}

