/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.mappers;

import com.priocom.web.ActionHandler;
import com.priocom.web.ActionOutcomeProcessor;
import com.priocom.web.PropertiesPopulator;
import com.priocom.web.handlers.ActionBuilder;
import com.priocom.web.handlers.NamedActionHandler;
import com.priocom.web.mappers.JavaUriActionMapper;
import com.priocom.web.utils.ServletUtils;
import com.priocom.web.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;

public class PackageJavaUriActionMapper
extends JavaUriActionMapper {
    private final String actionPrefix;
    private final String actionPackage;
    private final String actionSuffix;

    public PackageJavaUriActionMapper(String actionPrefix, String actionPackage, String actionSuffix, PropertiesPopulator propertiesPopulator, ActionOutcomeProcessor outcomeProcessor, ActionBuilder actionBuilder) {
        super(actionPrefix, actionPackage, actionSuffix, propertiesPopulator, outcomeProcessor, actionBuilder);
        this.actionPrefix = actionPrefix;
        this.actionPackage = actionPackage;
        this.actionSuffix = actionSuffix;
    }

    protected String getActionObjectName(HttpServletRequest httpServletRequest) {
        String servletPath = ServletUtils.getOriginalServletPath(httpServletRequest);
        String scriptPath = servletPath.substring(0, servletPath.lastIndexOf(47));
        if ("".equals(scriptPath)) {
            return null;
        }
        String name = String.valueOf(this.actionPackage) + "." + scriptPath.substring(this.actionPrefix.length()).replaceAll("/", ".");
        int pos = name.lastIndexOf(".");
        String classname = name.substring(pos + 1);
        return String.valueOf(name) + "." + StringUtils.capitalizeFirstLetter(classname);
    }

    public URI getURI(ActionHandler actionHandler) {
        NamedActionHandler classMethodActionHandler = (NamedActionHandler)actionHandler;
        String className = classMethodActionHandler.getObjectName();
        String classPart = className.substring(this.actionPackage.length() + 1);
        classPart = StringUtils.decapitalizeFirstLetters(classPart.substring(classPart.lastIndexOf(46) + 1), "/");
        String url = String.valueOf(this.actionPrefix) + classPart.replaceAll("\\.", "/") + "/" + classMethodActionHandler.getMethodName() + this.actionSuffix;
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("can't get URL from action", e);
        }
    }
}

