/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.mappers;

import com.priocom.web.ActionHandler;
import com.priocom.web.ActionOutcomeProcessor;
import com.priocom.web.PropertiesPopulator;
import com.priocom.web.handlers.ActionBuilder;
import com.priocom.web.handlers.ClassNamedActionForwardHandler;
import com.priocom.web.handlers.NamedActionForwardHandler;
import com.priocom.web.handlers.NamedActionHandler;
import com.priocom.web.mappers.AbstractClassMethodUriMapper;
import com.priocom.web.utils.ServletUtils;
import com.priocom.web.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class JavaUriActionMapper
extends AbstractClassMethodUriMapper {
    private final String actionPrefix;
    private final String actionSuffix;
    private final String actionPackage;
    private final PropertiesPopulator propertiesPopulator;
    private final ActionOutcomeProcessor outcomeProcessor;
    private final ActionBuilder actionBuilder;

    public JavaUriActionMapper(String actionPrefix, String actionPackage, String actionSuffix, PropertiesPopulator propertiesPopulator, ActionOutcomeProcessor outcomeProcessor, ActionBuilder actionBuilder) {
        this.propertiesPopulator = propertiesPopulator;
        this.outcomeProcessor = outcomeProcessor;
        this.actionBuilder = actionBuilder;
        if (actionPrefix == null || actionPackage == null) {
            throw new RuntimeException("Both actionPrefix and actionPackage cannot be null");
        }
        if (!actionPrefix.endsWith("/")) {
            throw new RuntimeException("actionPrefix must ends with \"/\" character.");
        }
        if (actionPackage.endsWith(".")) {
            throw new RuntimeException("actionPackage must not ends with \".\" character.");
        }
        this.actionPrefix = actionPrefix;
        this.actionSuffix = actionSuffix;
        this.actionPackage = actionPackage;
    }

    protected String getActionObjectName(HttpServletRequest httpServletRequest) {
        String servletPath = ServletUtils.getOriginalServletPath(httpServletRequest);
        String scriptPath = servletPath.substring(0, servletPath.lastIndexOf(47));
        if ("".equals(scriptPath)) {
            return null;
        }
        String name = String.valueOf(this.actionPackage) + "." + scriptPath.substring(this.actionPrefix.length()).replaceAll("/", ".");
        int pos = name.lastIndexOf(".");
        return String.valueOf(name.substring(0, pos + 1)) + StringUtils.capitalizeFirstLetter(name.substring(pos + 1));
    }

    public URI getURI(ActionHandler actionHandler) {
        NamedActionHandler classMethodActionHandler = (NamedActionHandler)actionHandler;
        String className = classMethodActionHandler.getObjectName();
        String classPart = className.substring(this.actionPackage.length() + 1).replaceAll("\\.", "/");
        String url = String.valueOf(this.actionPrefix) + StringUtils.decapitalizeFirstLetters(classPart, "/") + "/" + classMethodActionHandler.getMethodName() + this.actionSuffix;
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("can't get URL from action", e);
        }
    }

    protected NamedActionForwardHandler createHandler(String actionObjectName, String actionMethodName, ServletContext servletContext) {
        Class<?> actionClass;
        try {
            actionClass = Thread.currentThread().getContextClassLoader().loadClass(actionObjectName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return new ClassNamedActionForwardHandler(actionObjectName, actionMethodName, this.propertiesPopulator, this.outcomeProcessor, actionClass, this.actionBuilder);
    }
}

